/*
 * Decompiled with CFR 0.152.
 */
package com.watabou.pixeldungeon.items.scrolls;

import com.watabou.pixeldungeon.Badges;
import com.watabou.pixeldungeon.Dungeon;
import com.watabou.pixeldungeon.effects.Speck;
import com.watabou.pixeldungeon.items.Item;
import com.watabou.pixeldungeon.items.scrolls.InventoryScroll;
import com.watabou.pixeldungeon.items.scrolls.ScrollOfRemoveCurse;
import com.watabou.pixeldungeon.items.weapon.Weapon;
import com.watabou.pixeldungeon.utils.GLog;
import com.watabou.pixeldungeon.utils.Utils;
import com.watabou.pixeldungeon.windows.WndBag;

public class ScrollOfWeaponUpgrade
extends InventoryScroll {
    private static final String TXT_LOOKS_BETTER = "your %s certainly looks better now";

    public ScrollOfWeaponUpgrade() {
        this.name = "Scroll of Weapon Upgrade";
        this.inventoryTitle = "Select a weapon to upgrade";
        this.mode = WndBag.Mode.WEAPON;
    }

    @Override
    protected void onItemSelected(Item item) {
        Weapon weapon = (Weapon)item;
        ScrollOfRemoveCurse.uncurse(Dungeon.hero, weapon);
        weapon.upgrade(true);
        GLog.p(Utils.format(TXT_LOOKS_BETTER, weapon.name()), new Object[0]);
        Badges.validateItemLevelAquired(weapon);
        ScrollOfWeaponUpgrade.curUser.sprite.emitter().start(Speck.factory(4), 0.2f, 3);
    }

    @Override
    public String desc() {
        return "This scroll will upgrade a melee weapon, improving its quality. In contrast to a regular Scroll of Upgrade, this specialized version will never destroy an enchantment on a weapon. On the contrary, it is able to imbue an unenchanted weapon with a random enchantment.";
    }
}

