/*
 * Decompiled with CFR 0.152.
 */
package com.watabou.pixeldungeon.items.scrolls;

import com.watabou.pixeldungeon.Badges;
import com.watabou.pixeldungeon.Dungeon;
import com.watabou.pixeldungeon.actors.hero.Hero;
import com.watabou.pixeldungeon.effects.Speck;
import com.watabou.pixeldungeon.items.Item;
import com.watabou.pixeldungeon.items.scrolls.InventoryScroll;
import com.watabou.pixeldungeon.items.scrolls.ScrollOfRemoveCurse;
import com.watabou.pixeldungeon.utils.GLog;
import com.watabou.pixeldungeon.utils.Utils;
import com.watabou.pixeldungeon.windows.WndBag;

public class ScrollOfUpgrade
extends InventoryScroll {
    private static final String TXT_LOOKS_BETTER = "your %s certainly looks better now";

    public ScrollOfUpgrade() {
        this.name = "Scroll of Upgrade";
        this.inventoryTitle = "Select an item to upgrade";
        this.mode = WndBag.Mode.UPGRADEABLE;
    }

    @Override
    protected void onItemSelected(Item item) {
        ScrollOfRemoveCurse.uncurse(Dungeon.hero, item);
        item.upgrade();
        GLog.p(Utils.format(TXT_LOOKS_BETTER, item.name()), new Object[0]);
        Badges.validateItemLevelAquired(item);
        ScrollOfUpgrade.upgrade(curUser);
    }

    public static void upgrade(Hero hero) {
        hero.sprite.emitter().start(Speck.factory(4), 0.2f, 3);
    }

    @Override
    public String desc() {
        return "This scroll will upgrade a single item, improving its quality. A wand will increase in power and in number of charges; a weapon will inflict more damage or find its mark more frequently; a suit of armor will deflect additional blows; the effect of a ring on its wearer will intensify. Weapons and armor will also require less strength to use, and any curses on the item will be lifted.";
    }
}

