/*
 * Decompiled with CFR 0.152.
 */
package com.watabou.pixeldungeon.items.scrolls;

import com.watabou.noosa.audio.Sample;
import com.watabou.pixeldungeon.Dungeon;
import com.watabou.pixeldungeon.actors.buffs.Buff;
import com.watabou.pixeldungeon.actors.buffs.Invisibility;
import com.watabou.pixeldungeon.actors.buffs.Terror;
import com.watabou.pixeldungeon.actors.mobs.Mob;
import com.watabou.pixeldungeon.effects.Flare;
import com.watabou.pixeldungeon.items.scrolls.Scroll;
import com.watabou.pixeldungeon.levels.Level;
import com.watabou.pixeldungeon.utils.GLog;

public class ScrollOfTerror
extends Scroll {
    public ScrollOfTerror() {
        this.name = "Scroll of Terror";
    }

    @Override
    protected void doRead() {
        new Flare(5, 32.0f).color(0xFF0000, true).show(ScrollOfTerror.curUser.sprite, 2.0f);
        Sample.INSTANCE.play("snd_read.mp3");
        Invisibility.dispel();
        int count = 0;
        Mob affected = null;
        for (Mob mob : Dungeon.level.mobs.toArray(new Mob[0])) {
            if (!Level.fieldOfView[mob.pos]) continue;
            Terror terror = Buff.affect(mob, Terror.class, 10.0f);
            terror.source = curUser;
            ++count;
            affected = mob;
        }
        switch (count) {
            case 0: {
                GLog.i("The scroll emits a brilliant flash of red light", new Object[0]);
                break;
            }
            case 1: {
                GLog.i("The scroll emits a brilliant flash of red light and the %s flees!", affected.name);
                break;
            }
            default: {
                GLog.i("The scroll emits a brilliant flash of red light and the monsters flee!", new Object[0]);
            }
        }
        this.setKnown();
        curUser.spendAndNext(1.0f);
    }

    @Override
    public String desc() {
        return "A flash of red light will overwhelm all creatures in your field of view with terror, and they will turn and flee. Attacking a fleeing enemy will dispel the effect.";
    }

    @Override
    public int price() {
        return this.isKnown() ? 50 * this.quantity : super.price();
    }
}

