/*
 * Decompiled with CFR 0.152.
 */
package com.watabou.pixeldungeon.items.scrolls;

import com.watabou.noosa.audio.Sample;
import com.watabou.pixeldungeon.Dungeon;
import com.watabou.pixeldungeon.actors.buffs.Invisibility;
import com.watabou.pixeldungeon.actors.hero.Hero;
import com.watabou.pixeldungeon.items.scrolls.Scroll;
import com.watabou.pixeldungeon.items.wands.WandOfBlink;
import com.watabou.pixeldungeon.utils.GLog;

public class ScrollOfTeleportation
extends Scroll {
    public static final String TXT_TELEPORTED = "In a blink of an eye you were teleported to another location of the level.";
    public static final String TXT_NO_TELEPORT = "Strong magic aura of this place prevents you from teleporting!";

    public ScrollOfTeleportation() {
        this.name = "Scroll of Teleportation";
    }

    @Override
    protected void doRead() {
        Sample.INSTANCE.play("snd_read.mp3");
        Invisibility.dispel();
        ScrollOfTeleportation.teleportHero(curUser);
        this.setKnown();
        curUser.spendAndNext(1.0f);
    }

    public static void teleportHero(Hero hero) {
        int pos;
        int count = 10;
        do {
            pos = Dungeon.level.randomRespawnCell();
        } while (count-- > 0 && pos == -1);
        if (pos == -1) {
            GLog.w(TXT_NO_TELEPORT, new Object[0]);
        } else {
            WandOfBlink.appear(hero, pos);
            Dungeon.level.press(pos, hero);
            Dungeon.observe();
            GLog.i(TXT_TELEPORTED, new Object[0]);
        }
    }

    @Override
    public String desc() {
        return "The spell on this parchment instantly transports the reader to a random location on the dungeon level. It can be used to escape a dangerous situation, but the unlucky reader might find himself in an even more dangerous place.";
    }

    @Override
    public int price() {
        return this.isKnown() ? 40 * this.quantity : super.price();
    }
}

