/*
 * Decompiled with CFR 0.152.
 */
package com.watabou.pixeldungeon.items.scrolls;

import com.watabou.noosa.audio.Sample;
import com.watabou.pixeldungeon.actors.buffs.Invisibility;
import com.watabou.pixeldungeon.actors.hero.Hero;
import com.watabou.pixeldungeon.effects.SpellSprite;
import com.watabou.pixeldungeon.effects.particles.EnergyParticle;
import com.watabou.pixeldungeon.items.scrolls.Scroll;
import com.watabou.pixeldungeon.utils.GLog;

public class ScrollOfRecharging
extends Scroll {
    public ScrollOfRecharging() {
        this.name = "Scroll of Recharging";
    }

    @Override
    protected void doRead() {
        int count = ScrollOfRecharging.curUser.belongings.charge(true);
        ScrollOfRecharging.charge(curUser);
        Sample.INSTANCE.play("snd_read.mp3");
        Invisibility.dispel();
        if (count > 0) {
            GLog.i("a surge of energy courses through your pack, recharging your wand" + (count > 1 ? "s" : ""), new Object[0]);
            SpellSprite.show(curUser, 2);
        } else {
            GLog.i("a surge of energy courses through your pack, but nothing happens", new Object[0]);
        }
        this.setKnown();
        curUser.spendAndNext(1.0f);
    }

    @Override
    public String desc() {
        return "The raw magical power bound up in this parchment will, when released, recharge all of the reader's wands to full power.";
    }

    public static void charge(Hero hero) {
        hero.sprite.centerEmitter().burst(EnergyParticle.FACTORY, 15);
    }

    @Override
    public int price() {
        return this.isKnown() ? 40 * this.quantity : super.price();
    }
}

