/*
 * Decompiled with CFR 0.152.
 */
package com.watabou.pixeldungeon.items.scrolls;

import com.watabou.noosa.audio.Sample;
import com.watabou.pixeldungeon.Dungeon;
import com.watabou.pixeldungeon.actors.buffs.Blindness;
import com.watabou.pixeldungeon.actors.buffs.Buff;
import com.watabou.pixeldungeon.actors.buffs.Invisibility;
import com.watabou.pixeldungeon.actors.mobs.Mob;
import com.watabou.pixeldungeon.items.scrolls.Scroll;
import com.watabou.pixeldungeon.levels.Level;
import com.watabou.pixeldungeon.scenes.GameScene;
import com.watabou.utils.Random;

public class ScrollOfPsionicBlast
extends Scroll {
    public ScrollOfPsionicBlast() {
        this.name = "Scroll of Psionic Blast";
    }

    @Override
    protected void doRead() {
        GameScene.flash(0xFFFFFF);
        Sample.INSTANCE.play("snd_blast.mp3");
        Invisibility.dispel();
        for (Mob mob : Dungeon.level.mobs.toArray(new Mob[0])) {
            if (!Level.fieldOfView[mob.pos]) continue;
            Buff.prolong(mob, Blindness.class, Random.Int(3, 6));
            mob.damage(Random.IntRange(1, mob.HT * 2 / 3), this);
        }
        Buff.prolong(curUser, Blindness.class, Random.Int(3, 6));
        Dungeon.observe();
        this.setKnown();
        curUser.spendAndNext(1.0f);
    }

    @Override
    public String desc() {
        return "This scroll contains destructive energy, that can be psionically channeled to inflict a massive damage to all creatures within a field of view. An accompanying flash of light will temporarily blind everybody in the area of effect including the reader of the scroll.";
    }

    @Override
    public int price() {
        return this.isKnown() ? 80 * this.quantity : super.price();
    }
}

