/*
 * Decompiled with CFR 0.152.
 */
package com.watabou.pixeldungeon.items.scrolls;

import com.watabou.noosa.audio.Sample;
import com.watabou.pixeldungeon.actors.Actor;
import com.watabou.pixeldungeon.actors.buffs.Invisibility;
import com.watabou.pixeldungeon.actors.mobs.npcs.MirrorImage;
import com.watabou.pixeldungeon.items.scrolls.Scroll;
import com.watabou.pixeldungeon.items.wands.WandOfBlink;
import com.watabou.pixeldungeon.levels.Level;
import com.watabou.pixeldungeon.scenes.GameScene;
import com.watabou.utils.Random;
import java.util.ArrayList;

public class ScrollOfMirrorImage
extends Scroll {
    private static final int NIMAGES = 3;

    public ScrollOfMirrorImage() {
        this.name = "Scroll of Mirror Image";
    }

    @Override
    protected void doRead() {
        int nImages;
        ArrayList<Integer> respawnPoints = new ArrayList<Integer>();
        for (int i = 0; i < Level.NEIGHBOURS8.length; ++i) {
            int p = ScrollOfMirrorImage.curUser.pos + Level.NEIGHBOURS8[i];
            if (Actor.findChar(p) != null || !Level.passable[p] && !Level.avoid[p]) continue;
            respawnPoints.add(p);
        }
        for (nImages = 3; nImages > 0 && respawnPoints.size() > 0; --nImages) {
            int index = Random.index(respawnPoints);
            MirrorImage mob = new MirrorImage();
            mob.duplicate(curUser);
            GameScene.add(mob);
            WandOfBlink.appear(mob, (Integer)respawnPoints.get(index));
            respawnPoints.remove(index);
        }
        if (nImages < 3) {
            this.setKnown();
        }
        Sample.INSTANCE.play("snd_read.mp3");
        Invisibility.dispel();
        curUser.spendAndNext(1.0f);
    }

    @Override
    public String desc() {
        return "The incantation on this scroll will create illusionary twins of the reader, which will chase his enemies.";
    }
}

