/*
 * Decompiled with CFR 0.152.
 */
package com.watabou.pixeldungeon.items.scrolls;

import com.watabou.noosa.audio.Sample;
import com.watabou.pixeldungeon.Dungeon;
import com.watabou.pixeldungeon.actors.buffs.Buff;
import com.watabou.pixeldungeon.actors.buffs.Invisibility;
import com.watabou.pixeldungeon.actors.buffs.Sleep;
import com.watabou.pixeldungeon.actors.mobs.Mob;
import com.watabou.pixeldungeon.effects.Speck;
import com.watabou.pixeldungeon.items.scrolls.Scroll;
import com.watabou.pixeldungeon.levels.Level;
import com.watabou.pixeldungeon.utils.GLog;

public class ScrollOfLullaby
extends Scroll {
    public ScrollOfLullaby() {
        this.name = "Scroll of Lullaby";
    }

    @Override
    protected void doRead() {
        ScrollOfLullaby.curUser.sprite.centerEmitter().start(Speck.factory(9), 0.3f, 5);
        Sample.INSTANCE.play("snd_lullaby.mp3");
        Invisibility.dispel();
        int count = 0;
        Mob affected = null;
        for (Mob mob : Dungeon.level.mobs.toArray(new Mob[0])) {
            if (!Level.fieldOfView[mob.pos]) continue;
            Buff.affect(mob, Sleep.class);
            if (mob.buff(Sleep.class) == null) continue;
            affected = mob;
            ++count;
        }
        switch (count) {
            case 0: {
                GLog.i("The scroll utters a soothing melody.", new Object[0]);
                break;
            }
            case 1: {
                GLog.i("The scroll utters a soothing melody and the %s falls asleep!", affected.name);
                break;
            }
            default: {
                GLog.i("The scroll utters a soothing melody and the monsters fall asleep!", new Object[0]);
            }
        }
        this.setKnown();
        curUser.spendAndNext(1.0f);
    }

    @Override
    public String desc() {
        return "A soothing melody will put all creatures in your field of view into a deep sleep, giving you a chance to flee or make a surprise attack on them.";
    }

    @Override
    public int price() {
        return this.isKnown() ? 50 * this.quantity : super.price();
    }
}

