/*
 * Decompiled with CFR 0.152.
 */
package com.watabou.pixeldungeon.items.rings;

import com.watabou.pixeldungeon.Badges;
import com.watabou.pixeldungeon.Dungeon;
import com.watabou.pixeldungeon.actors.Char;
import com.watabou.pixeldungeon.actors.buffs.Buff;
import com.watabou.pixeldungeon.actors.hero.Hero;
import com.watabou.pixeldungeon.actors.hero.HeroClass;
import com.watabou.pixeldungeon.items.EquipableItem;
import com.watabou.pixeldungeon.items.Item;
import com.watabou.pixeldungeon.items.ItemStatusHandler;
import com.watabou.pixeldungeon.items.rings.RingOfAccuracy;
import com.watabou.pixeldungeon.items.rings.RingOfDetection;
import com.watabou.pixeldungeon.items.rings.RingOfElements;
import com.watabou.pixeldungeon.items.rings.RingOfEvasion;
import com.watabou.pixeldungeon.items.rings.RingOfHaggler;
import com.watabou.pixeldungeon.items.rings.RingOfHaste;
import com.watabou.pixeldungeon.items.rings.RingOfHerbalism;
import com.watabou.pixeldungeon.items.rings.RingOfMending;
import com.watabou.pixeldungeon.items.rings.RingOfPower;
import com.watabou.pixeldungeon.items.rings.RingOfSatiety;
import com.watabou.pixeldungeon.items.rings.RingOfShadows;
import com.watabou.pixeldungeon.items.rings.RingOfThorns;
import com.watabou.pixeldungeon.utils.GLog;
import com.watabou.pixeldungeon.utils.Utils;
import com.watabou.utils.Bundle;
import com.watabou.utils.Random;
import java.util.ArrayList;
import net.whitegem.pixeldungeon.LanguageFactory;

public class Ring
extends EquipableItem {
    private static final float TIME_TO_EQUIP = 1.0f;
    private static final String TXT_IDENTIFY = "you are now familiar enough with your %s to identify it. It is %s.";
    protected Buff buff;
    private static final Class<?>[] rings = new Class[]{RingOfMending.class, RingOfDetection.class, RingOfShadows.class, RingOfPower.class, RingOfHerbalism.class, RingOfAccuracy.class, RingOfEvasion.class, RingOfSatiety.class, RingOfHaste.class, RingOfHaggler.class, RingOfElements.class, RingOfThorns.class};
    private static final String[] gems = new String[]{"diamond", "opal", "garnet", "ruby", "amethyst", "topaz", "onyx", "tourmaline", "emerald", "sapphire", "quartz", "agate"};
    private static final Integer[] images = new Integer[]{32, 33, 34, 35, 36, 37, 38, 39, 72, 73, 74, 75};
    private static ItemStatusHandler<Ring> handler;
    private String gem;
    private int ticksToKnow = 200;

    public static void initGems() {
        handler = new ItemStatusHandler(rings, gems, images);
    }

    public static void save(Bundle bundle) {
        handler.save(bundle);
    }

    public static void restore(Bundle bundle) {
        handler = new ItemStatusHandler(rings, gems, images, bundle);
    }

    public Ring() {
        this.syncGem();
    }

    public void syncGem() {
        this.image = handler.image(this);
        this.gem = handler.label(this);
    }

    @Override
    public ArrayList<String> actions(Hero hero) {
        ArrayList<String> actions = super.actions(hero);
        actions.add(this.isEquipped(hero) ? "UNEQUIP" : "EQUIP");
        return actions;
    }

    @Override
    public boolean doEquip(Hero hero) {
        if (hero.belongings.ring1 != null && hero.belongings.ring2 != null) {
            GLog.w("you can only wear 2 rings at a time", new Object[0]);
            return false;
        }
        if (hero.belongings.ring1 == null) {
            hero.belongings.ring1 = this;
        } else {
            hero.belongings.ring2 = this;
        }
        this.detach(hero.belongings.backpack);
        this.activate(hero);
        this.cursedKnown = true;
        if (this.cursed) {
            Ring.equipCursed(hero);
            GLog.n(Utils.format("your %s tightens around your finger painfully", this), new Object[0]);
        }
        hero.spendAndNext(1.0f);
        return true;
    }

    public void activate(Char ch) {
        this.buff = this.buff();
        this.buff.attachTo(ch);
    }

    @Override
    public boolean doUnequip(Hero hero, boolean collect, boolean single) {
        if (super.doUnequip(hero, collect, single)) {
            if (hero.belongings.ring1 == this) {
                hero.belongings.ring1 = null;
            } else {
                hero.belongings.ring2 = null;
            }
            hero.remove(this.buff);
            this.buff = null;
            return true;
        }
        return false;
    }

    @Override
    public boolean isEquipped(Hero hero) {
        return hero.belongings.ring1 == this || hero.belongings.ring2 == this;
    }

    @Override
    public Item upgrade() {
        super.upgrade();
        if (this.buff != null) {
            Char owner = this.buff.target;
            this.buff.detach();
            this.buff = this.buff();
            if (this.buff != null) {
                this.buff.attachTo(owner);
            }
        }
        return this;
    }

    public boolean isKnown() {
        return handler.isKnown(this);
    }

    protected void setKnown() {
        if (!this.isKnown()) {
            handler.know(this);
        }
        Badges.validateAllRingsIdentified();
    }

    @Override
    public String name() {
        return this.isKnown() ? this.name : LanguageFactory.getTranslation(Utils.format("%s ring", this.gem));
    }

    @Override
    public String desc() {
        return Utils.format("This metal band is adorned with a large %s gem that glitters in the darkness. Who knows what effect it has when worn?", this.gem);
    }

    @Override
    public String info() {
        if (this.isEquipped(Dungeon.hero)) {
            return LanguageFactory.getTranslation(this.desc()) + "\n\n" + LanguageFactory.getTranslation(Utils.format("The %s is on your finger" + (this.cursed ? ", and because it is cursed, you are powerless to remove it." : "."), this.name()));
        }
        if (this.cursed && this.cursedKnown) {
            return LanguageFactory.getTranslation(this.desc()) + "\n\n" + LanguageFactory.getTranslation(Utils.format("You can feel a malevolent magic lurking within the %s.", this.name));
        }
        return LanguageFactory.getTranslation(this.desc());
    }

    @Override
    public boolean isIdentified() {
        return super.isIdentified() && this.isKnown();
    }

    @Override
    public Item identify() {
        this.setKnown();
        return super.identify();
    }

    @Override
    public Item random() {
        this.level = Random.Int(1, 3);
        if (Random.Float() < 0.3f) {
            this.level = -this.level;
            this.cursed = true;
        }
        return this;
    }

    public static boolean allKnown() {
        return handler.known().size() == rings.length - 2;
    }

    @Override
    public int price() {
        int price = 80;
        if (this.cursed && this.cursedKnown) {
            price /= 2;
        }
        if (this.levelKnown) {
            if (this.level > 0) {
                price *= this.level + 1;
            } else if (this.level < 0) {
                price /= 1 - this.level;
            }
        }
        if (price < 1) {
            price = 1;
        }
        return price;
    }

    protected RingBuff buff() {
        return null;
    }

    public class RingBuff
    extends Buff {
        private static final String TXT_KNOWN = "This is a %s";
        public int level;

        public RingBuff() {
            this.level = Ring.this.level;
        }

        @Override
        public boolean attachTo(Char target) {
            if (target instanceof Hero && ((Hero)target).heroClass == HeroClass.ROGUE && !Ring.this.isKnown()) {
                Ring.this.setKnown();
                GLog.i(Utils.format(TXT_KNOWN, Ring.this.name()), new Object[0]);
                Badges.validateItemLevelAquired(Ring.this);
            }
            return super.attachTo(target);
        }

        @Override
        public boolean act() {
            if (!Ring.this.isIdentified() && --Ring.this.ticksToKnow <= 0) {
                String gemName = Ring.this.name();
                Ring.this.identify();
                GLog.w(Utils.format(Ring.TXT_IDENTIFY, gemName, Ring.this.toString()), new Object[0]);
                Badges.validateItemLevelAquired(Ring.this);
            }
            this.spend(1.0f);
            return true;
        }
    }
}

