/*
 * Decompiled with CFR 0.152.
 */
package com.watabou.pixeldungeon.items.potions;

import com.watabou.noosa.audio.Sample;
import com.watabou.pixeldungeon.Dungeon;
import com.watabou.pixeldungeon.actors.blobs.Blob;
import com.watabou.pixeldungeon.actors.blobs.ParalyticGas;
import com.watabou.pixeldungeon.actors.blobs.ToxicGas;
import com.watabou.pixeldungeon.actors.buffs.Buff;
import com.watabou.pixeldungeon.actors.buffs.GasesImmunity;
import com.watabou.pixeldungeon.actors.hero.Hero;
import com.watabou.pixeldungeon.effects.CellEmitter;
import com.watabou.pixeldungeon.effects.Speck;
import com.watabou.pixeldungeon.items.potions.Potion;
import com.watabou.pixeldungeon.levels.Level;
import com.watabou.pixeldungeon.utils.BArray;
import com.watabou.pixeldungeon.utils.GLog;
import com.watabou.utils.PathFinder;

public class PotionOfPurity
extends Potion {
    private static final String TXT_FRESHNESS = "You feel uncommon freshness in the air.";
    private static final String TXT_NO_SMELL = "You've stopped sensing any smells!";
    private static final int DISTANCE = 2;

    public PotionOfPurity() {
        this.name = "Potion of Purification";
    }

    @Override
    protected void shatter(int cell) {
        boolean heroAffected;
        PathFinder.buildDistanceMap(cell, BArray.not(Level.losBlocking, null), 2);
        boolean procd = false;
        Blob[] blobs = new Blob[]{Dungeon.level.blobs.get(ToxicGas.class), Dungeon.level.blobs.get(ParalyticGas.class)};
        for (int j = 0; j < blobs.length; ++j) {
            Blob blob = blobs[j];
            if (blob == null) continue;
            for (int i = 0; i < 1024; ++i) {
                int value;
                if (PathFinder.distance[i] >= Integer.MAX_VALUE || (value = blob.cur[i]) <= 0) continue;
                blob.cur[i] = 0;
                blob.volume -= value;
                procd = true;
                CellEmitter.get(i).burst(Speck.factory(101), 1);
            }
        }
        boolean bl = heroAffected = PathFinder.distance[Dungeon.hero.pos] < Integer.MAX_VALUE;
        if (procd) {
            this.splash(cell);
            Sample.INSTANCE.play("snd_shatter.mp3");
            this.setKnown();
            if (heroAffected) {
                GLog.p(TXT_FRESHNESS, new Object[0]);
            }
        } else {
            super.shatter(cell);
            if (heroAffected) {
                GLog.i(TXT_FRESHNESS, new Object[0]);
                this.setKnown();
            }
        }
    }

    @Override
    protected void apply(Hero hero) {
        GLog.w(TXT_NO_SMELL, new Object[0]);
        Buff.prolong(hero, GasesImmunity.class, 5.0f);
        this.setKnown();
    }

    @Override
    public String desc() {
        return "This reagent will quickly neutralize all harmful gases in the area of effect. Drinking it will give you a temporary immunity to such gases.";
    }

    @Override
    public int price() {
        return this.isKnown() ? 50 * this.quantity : super.price();
    }
}

