/*
 * Decompiled with CFR 0.152.
 */
package com.watabou.pixeldungeon.items.potions;

import com.watabou.pixeldungeon.Dungeon;
import com.watabou.pixeldungeon.actors.buffs.Buff;
import com.watabou.pixeldungeon.actors.buffs.MindVision;
import com.watabou.pixeldungeon.actors.hero.Hero;
import com.watabou.pixeldungeon.items.potions.Potion;
import com.watabou.pixeldungeon.utils.GLog;

public class PotionOfMindVision
extends Potion {
    public PotionOfMindVision() {
        this.name = "Potion of Mind Vision";
    }

    @Override
    protected void apply(Hero hero) {
        this.setKnown();
        Buff.affect(hero, MindVision.class, 20.0f);
        Dungeon.observe();
        if (Dungeon.level.mobs.size() > 0) {
            GLog.i("You can somehow feel the presence of other creatures' minds!", new Object[0]);
        } else {
            GLog.i("You can somehow tell that you are alone on this level at the moment.", new Object[0]);
        }
    }

    @Override
    public String desc() {
        return "After drinking this, your mind will become attuned to the psychic signature of distant creatures, enabling you to sense biological presences through walls. Also this potion will permit you to see through nearby walls and doors.";
    }

    @Override
    public int price() {
        return this.isKnown() ? 35 * this.quantity : super.price();
    }
}

