/*
 * Decompiled with CFR 0.152.
 */
package com.watabou.pixeldungeon.items.potions;

import com.watabou.noosa.audio.Sample;
import com.watabou.noosa.tweeners.AlphaTweener;
import com.watabou.pixeldungeon.actors.Char;
import com.watabou.pixeldungeon.actors.buffs.Buff;
import com.watabou.pixeldungeon.actors.buffs.Invisibility;
import com.watabou.pixeldungeon.actors.hero.Hero;
import com.watabou.pixeldungeon.items.potions.Potion;
import com.watabou.pixeldungeon.utils.GLog;

public class PotionOfInvisibility
extends Potion {
    private static final float ALPHA = 0.4f;

    public PotionOfInvisibility() {
        this.name = "Potion of Invisibility";
    }

    @Override
    protected void apply(Hero hero) {
        this.setKnown();
        Buff.affect(hero, Invisibility.class, 15.0f);
        GLog.i("You see your hands turn invisible!", new Object[0]);
        Sample.INSTANCE.play("snd_meld.mp3");
    }

    @Override
    public String desc() {
        return "Drinking this potion will render you temporarily invisible. While invisible, enemies will be unable to see you. Attacking an enemy, as well as using a wand or a scroll before enemy's eyes, will dispel the effect.";
    }

    @Override
    public int price() {
        return this.isKnown() ? 40 * this.quantity : super.price();
    }

    public static void melt(Char ch) {
        if (ch.sprite.parent != null) {
            ch.sprite.parent.add(new AlphaTweener(ch.sprite, 0.4f, 0.4f));
        } else {
            ch.sprite.alpha(0.4f);
        }
    }
}

