/*
 * Decompiled with CFR 0.152.
 */
package com.watabou.pixeldungeon.items.potions;

import com.watabou.noosa.audio.Sample;
import com.watabou.pixeldungeon.Dungeon;
import com.watabou.pixeldungeon.actors.blobs.Fire;
import com.watabou.pixeldungeon.actors.blobs.Freezing;
import com.watabou.pixeldungeon.items.potions.Potion;
import com.watabou.pixeldungeon.levels.Level;
import com.watabou.pixeldungeon.utils.BArray;
import com.watabou.utils.PathFinder;

public class PotionOfFrost
extends Potion {
    private static final int DISTANCE = 2;

    public PotionOfFrost() {
        this.name = "Potion of Frost";
    }

    @Override
    protected void shatter(int cell) {
        PathFinder.buildDistanceMap(cell, BArray.not(Level.losBlocking, null), 2);
        Fire fire = (Fire)Dungeon.level.blobs.get(Fire.class);
        for (int i = 0; i < 1024; ++i) {
            if (PathFinder.distance[i] >= Integer.MAX_VALUE) continue;
            Freezing.affect(i, fire);
        }
        this.splash(cell);
        Sample.INSTANCE.play("snd_shatter.mp3");
        this.setKnown();
    }

    @Override
    public String desc() {
        return "Upon exposure to open air this chemical will evaporate into a freezing cloud, causing any creature that contacts it to be frozen in place unable to act and move.";
    }

    @Override
    public int price() {
        return this.isKnown() ? 50 * this.quantity : super.price();
    }
}

