/*
 * Decompiled with CFR 0.152.
 */
package com.watabou.pixeldungeon.items.food;

import com.watabou.pixeldungeon.actors.buffs.Barkskin;
import com.watabou.pixeldungeon.actors.buffs.Bleeding;
import com.watabou.pixeldungeon.actors.buffs.Buff;
import com.watabou.pixeldungeon.actors.buffs.Cripple;
import com.watabou.pixeldungeon.actors.buffs.Invisibility;
import com.watabou.pixeldungeon.actors.buffs.Poison;
import com.watabou.pixeldungeon.actors.buffs.Weakness;
import com.watabou.pixeldungeon.actors.hero.Hero;
import com.watabou.pixeldungeon.effects.Speck;
import com.watabou.pixeldungeon.items.food.Food;
import com.watabou.pixeldungeon.items.food.MysteryMeat;
import com.watabou.pixeldungeon.utils.GLog;
import com.watabou.utils.Random;

public class FrozenCarpaccio
extends Food {
    public FrozenCarpaccio() {
        this.name = "frozen carpaccio";
        this.image = 116;
        this.energy = 100.0f;
    }

    @Override
    public void execute(Hero hero, String action) {
        super.execute(hero, action);
        if (action.equals("EAT")) {
            switch (Random.Int(5)) {
                case 0: {
                    GLog.i("You see your hands turn invisible!", new Object[0]);
                    Buff.affect(hero, Invisibility.class, 15.0f);
                    break;
                }
                case 1: {
                    GLog.i("You feel your skin hardens!", new Object[0]);
                    Buff.affect(hero, Barkskin.class).level(hero.HT / 4);
                    break;
                }
                case 2: {
                    GLog.i("Refreshing!", new Object[0]);
                    Buff.detach(hero, Poison.class);
                    Buff.detach(hero, Cripple.class);
                    Buff.detach(hero, Weakness.class);
                    Buff.detach(hero, Bleeding.class);
                    break;
                }
                case 3: {
                    GLog.i("You feel better!", new Object[0]);
                    if (hero.HP >= hero.HT) break;
                    hero.HP = Math.min(hero.HP + hero.HT / 4, hero.HT);
                    hero.sprite.emitter().burst(Speck.factory(0), 1);
                }
            }
        }
    }

    @Override
    public String info() {
        return "It's a piece of frozen raw meat. The only way to eat it is by cutting thin slices of it. And this way it's suprisingly good.";
    }

    @Override
    public int price() {
        return 10 * this.quantity;
    }

    public static Food cook(MysteryMeat ingredient) {
        FrozenCarpaccio result = new FrozenCarpaccio();
        result.quantity = ingredient.quantity();
        return result;
    }
}

