/*
 * Decompiled with CFR 0.152.
 */
package com.watabou.pixeldungeon.items.bags;

import com.watabou.pixeldungeon.Badges;
import com.watabou.pixeldungeon.actors.Char;
import com.watabou.pixeldungeon.actors.hero.Hero;
import com.watabou.pixeldungeon.items.Item;
import com.watabou.pixeldungeon.scenes.GameScene;
import com.watabou.pixeldungeon.windows.WndBag;
import com.watabou.utils.Bundlable;
import com.watabou.utils.Bundle;
import java.util.ArrayList;
import java.util.Iterator;

public class Bag
extends Item
implements Iterable<Item> {
    public static final String AC_OPEN = "OPEN";
    public Char owner;
    public ArrayList<Item> items;
    public int size;
    private static final String ITEMS = "inventory";

    public Bag() {
        this.image = 11;
        this.defaultAction = AC_OPEN;
        this.items = new ArrayList();
        this.size = 1;
    }

    @Override
    public ArrayList<String> actions(Hero hero) {
        ArrayList<String> actions = super.actions(hero);
        return actions;
    }

    @Override
    public void execute(Hero hero, String action) {
        if (action.equals(AC_OPEN)) {
            GameScene.show(new WndBag(this, null, WndBag.Mode.ALL, null));
        } else {
            super.execute(hero, action);
        }
    }

    @Override
    public boolean collect(Bag container) {
        if (super.collect(container)) {
            this.owner = container.owner;
            for (Item item : container.items.toArray(new Item[0])) {
                if (!this.grab(item)) continue;
                item.detachAll(container);
                item.collect(this);
            }
            Badges.validateAllBagsBought(this);
            return true;
        }
        return false;
    }

    @Override
    public void onDetach() {
        this.owner = null;
    }

    @Override
    public boolean isUpgradable() {
        return false;
    }

    @Override
    public boolean isIdentified() {
        return true;
    }

    public void clear() {
        this.items.clear();
    }

    @Override
    public void storeInBundle(Bundle bundle) {
        super.storeInBundle(bundle);
        bundle.put(ITEMS, this.items);
    }

    @Override
    public void restoreFromBundle(Bundle bundle) {
        super.restoreFromBundle(bundle);
        for (Bundlable item : bundle.getCollection(ITEMS)) {
            ((Item)item).collect(this);
        }
    }

    public boolean contains(Item item) {
        for (Item i : this.items) {
            if (i == item) {
                return true;
            }
            if (!(i instanceof Bag) || !((Bag)i).contains(item)) continue;
            return true;
        }
        return false;
    }

    public boolean grab(Item item) {
        return false;
    }

    @Override
    public Iterator<Item> iterator() {
        return new ItemIterator();
    }

    private class ItemIterator
    implements Iterator<Item> {
        private int index = 0;
        private Iterator<Item> nested = null;

        private ItemIterator() {
        }

        @Override
        public boolean hasNext() {
            if (this.nested != null) {
                return this.nested.hasNext() || this.index < Bag.this.items.size();
            }
            return this.index < Bag.this.items.size();
        }

        @Override
        public Item next() {
            Item item;
            if (this.nested != null && this.nested.hasNext()) {
                return this.nested.next();
            }
            this.nested = null;
            if ((item = Bag.this.items.get(this.index++)) instanceof Bag) {
                this.nested = ((Bag)item).iterator();
            }
            return item;
        }

        @Override
        public void remove() {
            if (this.nested != null) {
                this.nested.remove();
            } else {
                Bag.this.items.remove(this.index);
            }
        }
    }
}

