/*
 * Decompiled with CFR 0.152.
 */
package com.watabou.pixeldungeon.items.armor.glyphs;

import com.watabou.pixeldungeon.Badges;
import com.watabou.pixeldungeon.Dungeon;
import com.watabou.pixeldungeon.actors.Char;
import com.watabou.pixeldungeon.actors.buffs.Buff;
import com.watabou.pixeldungeon.items.armor.Armor;
import com.watabou.pixeldungeon.sprites.ItemSprite;
import com.watabou.pixeldungeon.utils.GLog;
import com.watabou.pixeldungeon.utils.Utils;
import com.watabou.utils.Bundle;
import com.watabou.utils.Random;

public class Viscosity
extends Armor.Glyph {
    private static final String TXT_VISCOSITY = "%s of viscosity";
    private static ItemSprite.Glowing PURPLE = new ItemSprite.Glowing(0x8844CC);

    @Override
    public int proc(Armor armor, Char attacker, Char defender, int damage) {
        if (damage == 0) {
            return 0;
        }
        int level = Math.max(0, armor.level);
        if (Random.Int(level + 7) >= 6) {
            DeferedDamage debuff = defender.buff(DeferedDamage.class);
            if (debuff == null) {
                debuff = new DeferedDamage();
                debuff.attachTo(defender);
            }
            debuff.prolong(damage);
            defender.sprite.showStatus(0xFF8800, "deferred %d", damage);
            return 0;
        }
        return damage;
    }

    @Override
    public String name(String weaponName) {
        return Utils.format(TXT_VISCOSITY, weaponName);
    }

    @Override
    public ItemSprite.Glowing glowing() {
        return PURPLE;
    }

    public static class DeferedDamage
    extends Buff {
        protected int damage = 0;
        private static final String DAMAGE = "damage";

        @Override
        public void storeInBundle(Bundle bundle) {
            super.storeInBundle(bundle);
            bundle.put(DAMAGE, this.damage);
        }

        @Override
        public void restoreFromBundle(Bundle bundle) {
            super.restoreFromBundle(bundle);
            this.damage = bundle.getInt(DAMAGE);
        }

        @Override
        public boolean attachTo(Char target) {
            if (super.attachTo(target)) {
                this.postpone(1.0f);
                return true;
            }
            return false;
        }

        public void prolong(int damage) {
            this.damage += damage;
        }

        @Override
        public int icon() {
            return 28;
        }

        public String toString() {
            return Utils.format("Defered damage (%d)", this.damage);
        }

        @Override
        public boolean act() {
            if (this.target.isAlive()) {
                this.target.damage(1, this);
                if (this.target == Dungeon.hero && !this.target.isAlive()) {
                    Viscosity glyph = new Viscosity();
                    Dungeon.fail(Utils.format("Killed by the %s on level %d", glyph.name(), Dungeon.depth));
                    GLog.n(Utils.format("%s killed you...", glyph.name()), new Object[0]);
                    Badges.validateDeathFromGlyph();
                }
                this.spend(1.0f);
                if (--this.damage <= 0) {
                    this.detach();
                }
            } else {
                this.detach();
            }
            return true;
        }
    }
}

