/*
 * Decompiled with CFR 0.152.
 */
package com.watabou.pixeldungeon.items.armor.glyphs;

import com.watabou.pixeldungeon.Dungeon;
import com.watabou.pixeldungeon.actors.Actor;
import com.watabou.pixeldungeon.actors.Char;
import com.watabou.pixeldungeon.actors.mobs.Mob;
import com.watabou.pixeldungeon.effects.Pushing;
import com.watabou.pixeldungeon.items.armor.Armor;
import com.watabou.pixeldungeon.levels.Level;
import com.watabou.pixeldungeon.utils.Utils;
import com.watabou.utils.Random;

public class Bounce
extends Armor.Glyph {
    private static final String TXT_BOUNCE = "%s of bounce";

    @Override
    public int proc(Armor armor, Char attacker, Char defender, int damage) {
        int level = Math.max(0, armor.level);
        if (Level.adjacent(attacker.pos, defender.pos) && Random.Int(level + 5) >= 4) {
            for (int i = 0; i < Level.NEIGHBOURS8.length; ++i) {
                int ofs = Level.NEIGHBOURS8[i];
                if (attacker.pos - defender.pos != ofs) continue;
                int newPos = attacker.pos + ofs;
                if (!Level.passable[newPos] && !Level.avoid[newPos] || Actor.findChar(newPos) != null) break;
                Actor.addDelayed(new Pushing(attacker, attacker.pos, newPos), -1.0f);
                attacker.pos = newPos;
                if (attacker instanceof Mob) {
                    Dungeon.level.mobPress((Mob)attacker);
                    break;
                }
                Dungeon.level.press(newPos, attacker);
                break;
            }
        }
        return damage;
    }

    @Override
    public String name(String weaponName) {
        return Utils.format(TXT_BOUNCE, weaponName);
    }
}

