/*
 * Decompiled with CFR 0.152.
 */
package com.watabou.pixeldungeon.items.armor.glyphs;

import com.watabou.pixeldungeon.actors.Char;
import com.watabou.pixeldungeon.actors.buffs.Buff;
import com.watabou.pixeldungeon.actors.buffs.Charm;
import com.watabou.pixeldungeon.effects.Speck;
import com.watabou.pixeldungeon.items.armor.Armor;
import com.watabou.pixeldungeon.levels.Level;
import com.watabou.pixeldungeon.sprites.ItemSprite;
import com.watabou.pixeldungeon.utils.Utils;
import com.watabou.utils.GameMath;
import com.watabou.utils.Random;

public class Affection
extends Armor.Glyph {
    private static final String TXT_AFFECTION = "%s of affection";
    private static ItemSprite.Glowing PINK = new ItemSprite.Glowing(0xFF4488);

    @Override
    public int proc(Armor armor, Char attacker, Char defender, int damage) {
        int level = (int)GameMath.gate(0.0f, armor.level, 6.0f);
        if (Level.adjacent(attacker.pos, defender.pos) && Random.Int(level / 2 + 5) >= 4) {
            int duration = Random.IntRange(2, 5);
            Buff.affect(attacker, Charm.class, Charm.durationFactor(attacker) * (float)duration);
            attacker.sprite.centerEmitter().start(Speck.factory(11), 0.2f, 5);
            Buff.affect(defender, Charm.class, Random.Float(Charm.durationFactor(defender) * (float)duration / 2.0f, duration));
            defender.sprite.centerEmitter().start(Speck.factory(11), 0.2f, 5);
        }
        return damage;
    }

    @Override
    public String name(String weaponName) {
        return Utils.format(TXT_AFFECTION, weaponName);
    }

    @Override
    public ItemSprite.Glowing glowing() {
        return PINK;
    }
}

