/*
 * Decompiled with CFR 0.152.
 */
package com.watabou.pixeldungeon.items.armor;

import com.watabou.noosa.audio.Sample;
import com.watabou.pixeldungeon.Dungeon;
import com.watabou.pixeldungeon.actors.buffs.Buff;
import com.watabou.pixeldungeon.actors.buffs.Burning;
import com.watabou.pixeldungeon.actors.buffs.Roots;
import com.watabou.pixeldungeon.actors.hero.Hero;
import com.watabou.pixeldungeon.actors.hero.HeroClass;
import com.watabou.pixeldungeon.actors.mobs.Mob;
import com.watabou.pixeldungeon.effects.particles.ElmoParticle;
import com.watabou.pixeldungeon.items.armor.ClassArmor;
import com.watabou.pixeldungeon.levels.Level;
import com.watabou.pixeldungeon.utils.GLog;

public class MageArmor
extends ClassArmor {
    private static final String AC_SPECIAL = "MOLTEN EARTH";
    private static final String TXT_NOT_MAGE = "Only mages can use this armor!";

    public MageArmor() {
        this.name = "mage robe";
        this.image = 98;
    }

    @Override
    public String special() {
        return AC_SPECIAL;
    }

    @Override
    public String desc() {
        return "Wearing this gorgeous robe, a mage can cast a spell of molten earth: all the enemies in his field of view will be set on fire and unable to move at the same time.";
    }

    @Override
    public void doSpecial() {
        for (Mob mob : Dungeon.level.mobs) {
            if (!Level.fieldOfView[mob.pos]) continue;
            Buff.affect(mob, Burning.class).reignite(mob);
            Buff.prolong(mob, Roots.class, 3.0f);
        }
        MageArmor.curUser.HP -= MageArmor.curUser.HP / 3;
        curUser.spend(1.0f);
        MageArmor.curUser.sprite.operate(MageArmor.curUser.pos);
        curUser.busy();
        MageArmor.curUser.sprite.centerEmitter().start(ElmoParticle.FACTORY, 0.15f, 4);
        Sample.INSTANCE.play("snd_read.mp3");
    }

    @Override
    public boolean doEquip(Hero hero) {
        if (hero.heroClass == HeroClass.MAGE) {
            return super.doEquip(hero);
        }
        GLog.w(TXT_NOT_MAGE, new Object[0]);
        return false;
    }
}

