/*
 * Decompiled with CFR 0.152.
 */
package com.watabou.pixeldungeon.items.armor;

import com.watabou.pixeldungeon.Badges;
import com.watabou.pixeldungeon.Dungeon;
import com.watabou.pixeldungeon.actors.Char;
import com.watabou.pixeldungeon.actors.hero.Hero;
import com.watabou.pixeldungeon.items.EquipableItem;
import com.watabou.pixeldungeon.items.Item;
import com.watabou.pixeldungeon.items.armor.glyphs.Affection;
import com.watabou.pixeldungeon.items.armor.glyphs.AntiEntropy;
import com.watabou.pixeldungeon.items.armor.glyphs.Bounce;
import com.watabou.pixeldungeon.items.armor.glyphs.Displacement;
import com.watabou.pixeldungeon.items.armor.glyphs.Entanglement;
import com.watabou.pixeldungeon.items.armor.glyphs.Metabolism;
import com.watabou.pixeldungeon.items.armor.glyphs.Multiplicity;
import com.watabou.pixeldungeon.items.armor.glyphs.Potential;
import com.watabou.pixeldungeon.items.armor.glyphs.Stench;
import com.watabou.pixeldungeon.items.armor.glyphs.Viscosity;
import com.watabou.pixeldungeon.sprites.HeroSprite;
import com.watabou.pixeldungeon.sprites.ItemSprite;
import com.watabou.pixeldungeon.utils.GLog;
import com.watabou.pixeldungeon.utils.Utils;
import com.watabou.utils.Bundlable;
import com.watabou.utils.Bundle;
import com.watabou.utils.Random;
import java.util.ArrayList;
import net.whitegem.pixeldungeon.LanguageFactory;

public class Armor
extends EquipableItem {
    private static final String TXT_EQUIP_CURSED = "your %s constricts around you painfully";
    private static final String TXT_IDENTIFY = "you are now familiar enough with your %s to identify it. It is %s.";
    private static final String TXT_TO_STRING = "%s :%d";
    private static final String TXT_INCOMPATIBLE = "Interaction of different types of magic has erased the glyph on this armor!";
    public int tier;
    public int STR;
    public int DR;
    private int hitsToKnow = 10;
    public Glyph glyph;
    private static final String GLYPH = "glyph";

    public Armor(int tier) {
        this.tier = tier;
        this.STR = this.typicalSTR();
        this.DR = this.typicalDR();
    }

    @Override
    public void storeInBundle(Bundle bundle) {
        super.storeInBundle(bundle);
        bundle.put(GLYPH, this.glyph);
    }

    @Override
    public void restoreFromBundle(Bundle bundle) {
        super.restoreFromBundle(bundle);
        this.glyph = (Glyph)bundle.get(GLYPH);
    }

    @Override
    public ArrayList<String> actions(Hero hero) {
        ArrayList<String> actions = super.actions(hero);
        actions.add(this.isEquipped(hero) ? "UNEQUIP" : "EQUIP");
        return actions;
    }

    @Override
    public boolean doEquip(Hero hero) {
        this.detach(hero.belongings.backpack);
        if (hero.belongings.armor == null || hero.belongings.armor.doUnequip(hero, true, false)) {
            hero.belongings.armor = this;
            this.cursedKnown = true;
            if (this.cursed) {
                Armor.equipCursed(hero);
                GLog.n(Utils.format(TXT_EQUIP_CURSED, this.toString()), new Object[0]);
            }
            ((HeroSprite)hero.sprite).updateArmor();
            hero.spendAndNext(2.0f * this.time2equip(hero));
            return true;
        }
        this.collect(hero.belongings.backpack);
        return false;
    }

    @Override
    protected float time2equip(Hero hero) {
        return hero.speed();
    }

    @Override
    public boolean doUnequip(Hero hero, boolean collect, boolean single) {
        if (super.doUnequip(hero, collect, single)) {
            hero.belongings.armor = null;
            ((HeroSprite)hero.sprite).updateArmor();
            return true;
        }
        return false;
    }

    @Override
    public boolean isEquipped(Hero hero) {
        return hero.belongings.armor == this;
    }

    @Override
    public Item upgrade() {
        return this.upgrade(false);
    }

    public Item upgrade(boolean inscribe) {
        if (this.glyph != null) {
            if (!inscribe && Random.Int(this.level) > 0) {
                GLog.w(TXT_INCOMPATIBLE, new Object[0]);
                this.inscribe(null);
            }
        } else if (inscribe) {
            this.inscribe(Glyph.random());
        }
        this.DR += this.tier;
        --this.STR;
        return super.upgrade();
    }

    public Item safeUpgrade() {
        return this.upgrade(this.glyph != null);
    }

    @Override
    public Item degrade() {
        this.DR -= this.tier;
        ++this.STR;
        return super.degrade();
    }

    public int proc(Char attacker, Char defender, int damage) {
        if (this.glyph != null) {
            damage = this.glyph.proc(this, attacker, defender, damage);
        }
        if (!this.levelKnown && --this.hitsToKnow <= 0) {
            this.levelKnown = true;
            GLog.w(Utils.format(TXT_IDENTIFY, this.name(), this.toString()), new Object[0]);
            Badges.validateItemLevelAquired(this);
        }
        return damage;
    }

    @Override
    public String toString() {
        return this.levelKnown ? Utils.format(TXT_TO_STRING, super.toString(), this.STR) : super.toString();
    }

    @Override
    public String name() {
        return this.glyph == null ? super.name() : this.glyph.name(super.name());
    }

    @Override
    public String info() {
        String name = this.name();
        StringBuilder info = new StringBuilder(LanguageFactory.getTranslation(this.desc()));
        if (this.levelKnown) {
            info.append("\n\n" + LanguageFactory.getTranslation(Utils.format("This %s provides damage absorption up to %d points per attack. ", name, Math.max(this.DR, 0))));
            if (this.STR > Dungeon.hero.STR()) {
                if (this.isEquipped(Dungeon.hero)) {
                    info.append("\n\n" + LanguageFactory.getTranslation("Because of your inadequate strength your movement speed and defense skill is decreased. "));
                } else {
                    info.append("\n\n" + LanguageFactory.getTranslation("Because of your inadequate strength wearing this armor will decrease your movement speed and defense skill. "));
                }
            }
        } else {
            info.append("\n\n" + LanguageFactory.getTranslation(Utils.format("Typical %s provides damage absorption up to %d points per attack and requires %d points of strength. ", name, this.typicalDR(), this.typicalSTR())));
            if (this.typicalSTR() > Dungeon.hero.STR()) {
                info.append(LanguageFactory.getTranslation("Probably this armor is too heavy for you. "));
            }
        }
        if (this.glyph != null) {
            info.append(LanguageFactory.getTranslation("It is inscribed."));
        }
        if (this.isEquipped(Dungeon.hero)) {
            info.append("\n\n" + LanguageFactory.getTranslation(Utils.format("You are wearing the %s" + (this.cursed ? ", and because it is cursed, you are powerless to remove it." : "."), name)));
        } else if (this.cursedKnown && this.cursed) {
            info.append("\n\n" + LanguageFactory.getTranslation(Utils.format("You can feel a malevolent magic lurking within the %s.", name)));
        }
        return info.toString();
    }

    @Override
    public Item random() {
        if ((double)Random.Float() < 0.4) {
            int n = 1;
            if (Random.Int(3) == 0) {
                ++n;
                if (Random.Int(3) == 0) {
                    ++n;
                }
            }
            if (Random.Int(2) == 0) {
                this.upgrade(n);
            } else {
                this.degrade(n);
                this.cursed = true;
            }
        }
        if (Random.Int(10) == 0) {
            this.inscribe(Glyph.random());
        }
        return this;
    }

    public int typicalSTR() {
        return 7 + this.tier * 2;
    }

    public int typicalDR() {
        return this.tier * 2;
    }

    @Override
    public int price() {
        int price = 10 * (1 << this.tier - 1);
        if (this.glyph != null) {
            price = (int)((double)price * 1.5);
        }
        if (this.cursed && this.cursedKnown) {
            price /= 2;
        }
        if (this.levelKnown) {
            if (this.level > 0) {
                price *= this.level + 1;
            } else if (this.level < 0) {
                price /= 1 - this.level;
            }
        }
        if (price < 1) {
            price = 1;
        }
        return price;
    }

    public Armor inscribe(Glyph glyph) {
        if (glyph != null && this.glyph == null) {
            this.DR += this.tier;
        } else if (glyph == null && this.glyph != null) {
            this.DR -= this.tier;
        }
        this.glyph = glyph;
        return this;
    }

    public boolean isInscribed() {
        return this.glyph != null;
    }

    @Override
    public ItemSprite.Glowing glowing() {
        return this.glyph != null ? this.glyph.glowing() : null;
    }

    public static abstract class Glyph
    implements Bundlable {
        private static final Class<?>[] glyphs = new Class[]{Bounce.class, Affection.class, AntiEntropy.class, Multiplicity.class, Potential.class, Metabolism.class, Stench.class, Viscosity.class, Displacement.class, Entanglement.class};
        private static final float[] chances = new float[]{1.0f, 1.0f, 1.0f, 1.0f, 1.0f, 1.0f, 1.0f, 1.0f, 1.0f, 1.0f};

        public abstract int proc(Armor var1, Char var2, Char var3, int var4);

        public String name() {
            return this.name(Armor.GLYPH);
        }

        public String name(String armorName) {
            return armorName;
        }

        @Override
        public void restoreFromBundle(Bundle bundle) {
        }

        @Override
        public void storeInBundle(Bundle bundle) {
        }

        public ItemSprite.Glowing glowing() {
            return ItemSprite.Glowing.WHITE;
        }

        public boolean checkOwner(Char owner) {
            if (!owner.isAlive() && owner instanceof Hero) {
                ((Hero)owner).killerGlyph = this;
                Badges.validateDeathFromGlyph();
                return true;
            }
            return false;
        }

        public static Glyph random() {
            try {
                return (Glyph)glyphs[Random.chances(chances)].newInstance();
            }
            catch (Exception e) {
                return null;
            }
        }
    }
}

