/*
 * Decompiled with CFR 0.152.
 */
package com.watabou.pixeldungeon.items;

import com.watabou.noosa.audio.Sample;
import com.watabou.pixeldungeon.Badges;
import com.watabou.pixeldungeon.actors.buffs.Blindness;
import com.watabou.pixeldungeon.actors.buffs.Buff;
import com.watabou.pixeldungeon.actors.buffs.Fury;
import com.watabou.pixeldungeon.actors.hero.Hero;
import com.watabou.pixeldungeon.actors.hero.HeroSubClass;
import com.watabou.pixeldungeon.effects.Speck;
import com.watabou.pixeldungeon.effects.SpellSprite;
import com.watabou.pixeldungeon.items.Item;
import com.watabou.pixeldungeon.scenes.GameScene;
import com.watabou.pixeldungeon.utils.GLog;
import com.watabou.pixeldungeon.utils.Utils;
import com.watabou.pixeldungeon.windows.WndChooseWay;
import java.util.ArrayList;

public class TomeOfMastery
extends Item {
    private static final String TXT_BLINDED = "You can't read while blinded";
    public static final float TIME_TO_READ = 10.0f;
    public static final String AC_READ = "READ";

    public TomeOfMastery() {
        this.stackable = false;
        this.name = "Tome of Mastery";
        this.image = 82;
        this.unique = true;
    }

    @Override
    public ArrayList<String> actions(Hero hero) {
        ArrayList<String> actions = super.actions(hero);
        actions.add(AC_READ);
        return actions;
    }

    @Override
    public void execute(Hero hero, String action) {
        if (action.equals(AC_READ)) {
            if (hero.buff(Blindness.class) != null) {
                GLog.w(TXT_BLINDED, new Object[0]);
                return;
            }
            curUser = hero;
            HeroSubClass way1 = null;
            HeroSubClass way2 = null;
            switch (hero.heroClass) {
                case WARRIOR: {
                    way1 = HeroSubClass.GLADIATOR;
                    way2 = HeroSubClass.BERSERKER;
                    break;
                }
                case MAGE: {
                    way1 = HeroSubClass.BATTLEMAGE;
                    way2 = HeroSubClass.WARLOCK;
                    break;
                }
                case ROGUE: {
                    way1 = HeroSubClass.FREERUNNER;
                    way2 = HeroSubClass.ASSASSIN;
                    break;
                }
                case HUNTRESS: {
                    way1 = HeroSubClass.SNIPER;
                    way2 = HeroSubClass.WARDEN;
                }
            }
            GameScene.show(new WndChooseWay(this, way1, way2));
        } else {
            super.execute(hero, action);
        }
    }

    @Override
    public boolean doPickUp(Hero hero) {
        Badges.validateMastery();
        return super.doPickUp(hero);
    }

    @Override
    public boolean isUpgradable() {
        return false;
    }

    @Override
    public boolean isIdentified() {
        return true;
    }

    @Override
    public String info() {
        return "This worn leather book is not that thick, but you feel somehow, that you can gather a lot from it. Remember though that reading this tome may require some time.";
    }

    public void choose(HeroSubClass way) {
        this.detach(TomeOfMastery.curUser.belongings.backpack);
        curUser.spend(10.0f);
        curUser.busy();
        TomeOfMastery.curUser.subClass = way;
        TomeOfMastery.curUser.sprite.operate(TomeOfMastery.curUser.pos);
        Sample.INSTANCE.play("snd_mastery.mp3");
        SpellSprite.show(curUser, 3);
        TomeOfMastery.curUser.sprite.emitter().burst(Speck.factory(103), 12);
        GLog.w(Utils.format("You have chosen the way of the %s!", Utils.capitalize(way.title())), new Object[0]);
        if (way == HeroSubClass.BERSERKER && (float)TomeOfMastery.curUser.HP <= (float)TomeOfMastery.curUser.HT * Fury.LEVEL) {
            Buff.affect(curUser, Fury.class);
        }
    }
}

