/*
 * Decompiled with CFR 0.152.
 */
package com.watabou.pixeldungeon.items;

import com.watabou.noosa.audio.Sample;
import com.watabou.pixeldungeon.actors.hero.Hero;
import com.watabou.pixeldungeon.effects.particles.PurpleParticle;
import com.watabou.pixeldungeon.items.Item;
import com.watabou.pixeldungeon.items.armor.Armor;
import com.watabou.pixeldungeon.scenes.GameScene;
import com.watabou.pixeldungeon.utils.GLog;
import com.watabou.pixeldungeon.utils.Utils;
import com.watabou.pixeldungeon.windows.WndBag;
import java.util.ArrayList;

public class Stylus
extends Item {
    private static final String TXT_SELECT_ARMOR = "Select an armor to inscribe on";
    private static final String TXT_INSCRIBED = "you inscribed the %s on your %s";
    private static final float TIME_TO_INSCRIBE = 2.0f;
    private static final String AC_INSCRIBE = "INSCRIBE";
    private final WndBag.Listener itemSelector;

    public Stylus() {
        this.name = "arcane stylus";
        this.image = 80;
        this.stackable = true;
        this.itemSelector = new WndBag.Listener(){

            @Override
            public void onSelect(Item item) {
                if (item != null) {
                    Stylus.this.inscribe((Armor)item);
                }
            }
        };
    }

    @Override
    public ArrayList<String> actions(Hero hero) {
        ArrayList<String> actions = super.actions(hero);
        actions.add(AC_INSCRIBE);
        return actions;
    }

    @Override
    public void execute(Hero hero, String action) {
        if (action == AC_INSCRIBE) {
            curUser = hero;
            GameScene.selectItem(this.itemSelector, WndBag.Mode.ARMOR, TXT_SELECT_ARMOR);
        } else {
            super.execute(hero, action);
        }
    }

    @Override
    public boolean isUpgradable() {
        return false;
    }

    @Override
    public boolean isIdentified() {
        return true;
    }

    private void inscribe(Armor armor) {
        this.detach(Stylus.curUser.belongings.backpack);
        Class<?> oldGlyphClass = armor.glyph != null ? armor.glyph.getClass() : null;
        Armor.Glyph glyph = Armor.Glyph.random();
        while (glyph.getClass() == oldGlyphClass) {
            glyph = Armor.Glyph.random();
        }
        GLog.w(Utils.format(TXT_INSCRIBED, glyph.name(), armor.name()), new Object[0]);
        armor.inscribe(glyph);
        Stylus.curUser.sprite.operate(Stylus.curUser.pos);
        Stylus.curUser.sprite.centerEmitter().start(PurpleParticle.BURST, 0.05f, 10);
        Sample.INSTANCE.play("snd_burning.mp3");
        curUser.spend(2.0f);
        curUser.busy();
    }

    @Override
    public int price() {
        return 50 * this.quantity;
    }

    @Override
    public String info() {
        return "This arcane stylus is made of some dark, very hard stone. Using it you can inscribe a magical glyph on your armor, but you have no power over choosing what glyph it will be, the stylus will decide it for you.";
    }
}

