/*
 * Decompiled with CFR 0.152.
 */
package com.watabou.pixeldungeon.items;

import com.watabou.pixeldungeon.actors.Char;
import com.watabou.pixeldungeon.actors.hero.Hero;
import com.watabou.pixeldungeon.items.EquipableItem;
import com.watabou.pixeldungeon.ui.QuickSlot;
import com.watabou.pixeldungeon.utils.GLog;
import com.watabou.pixeldungeon.utils.Utils;
import com.watabou.utils.Random;
import java.util.ArrayList;

public class KindOfWeapon
extends EquipableItem {
    private static final String TXT_EQUIP_CURSED = "you wince as your grip involuntarily tightens around your %s";
    protected static final float TIME_TO_EQUIP = 1.0f;
    public int MIN = 0;
    public int MAX = 1;

    @Override
    public ArrayList<String> actions(Hero hero) {
        ArrayList<String> actions = super.actions(hero);
        actions.add(this.isEquipped(hero) ? "UNEQUIP" : "EQUIP");
        return actions;
    }

    @Override
    public boolean isEquipped(Hero hero) {
        return hero.belongings.weapon == this;
    }

    @Override
    public boolean doEquip(Hero hero) {
        this.detachAll(hero.belongings.backpack);
        if (hero.belongings.weapon == null || hero.belongings.weapon.doUnequip(hero, true)) {
            hero.belongings.weapon = this;
            this.activate(hero);
            QuickSlot.refresh();
            this.cursedKnown = true;
            if (this.cursed) {
                KindOfWeapon.equipCursed(hero);
                GLog.n(Utils.format(TXT_EQUIP_CURSED, this.name()), new Object[0]);
            }
            hero.spendAndNext(1.0f);
            return true;
        }
        this.collect(hero.belongings.backpack);
        return false;
    }

    @Override
    public boolean doUnequip(Hero hero, boolean collect, boolean single) {
        if (super.doUnequip(hero, collect, single)) {
            hero.belongings.weapon = null;
            return true;
        }
        return false;
    }

    public void activate(Hero hero) {
    }

    public int damageRoll(Hero owner) {
        return Random.NormalIntRange(this.MIN, this.MAX);
    }

    public float acuracyFactor(Hero hero) {
        return 1.0f;
    }

    public float speedFactor(Hero hero) {
        return 1.0f;
    }

    public void proc(Char attacker, Char defender, int damage) {
    }
}

