/*
 * Decompiled with CFR 0.152.
 */
package com.watabou.pixeldungeon.items;

import com.watabou.pixeldungeon.items.Item;
import com.watabou.utils.Bundle;
import com.watabou.utils.Random;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;

public class ItemStatusHandler<T extends Item> {
    private Class<? extends T>[] items;
    private HashMap<Class<? extends T>, Integer> images;
    private HashMap<Class<? extends T>, String> labels;
    private HashSet<Class<? extends T>> known;
    private static final String PFX_IMAGE = "_image";
    private static final String PFX_LABEL = "_label";
    private static final String PFX_KNOWN = "_known";

    public ItemStatusHandler(Class<? extends T>[] items, String[] allLabels, Integer[] allImages) {
        this.items = items;
        this.images = new HashMap();
        this.labels = new HashMap();
        this.known = new HashSet();
        ArrayList<String> labelsLeft = new ArrayList<String>(Arrays.asList(allLabels));
        ArrayList<Integer> imagesLeft = new ArrayList<Integer>(Arrays.asList(allImages));
        for (int i = 0; i < items.length; ++i) {
            Class<? extends T> item = items[i];
            int index = Random.Int(labelsLeft.size());
            this.labels.put(item, labelsLeft.get(index));
            labelsLeft.remove(index);
            this.images.put(item, imagesLeft.get(index));
            imagesLeft.remove(index);
        }
    }

    public ItemStatusHandler(Class<? extends T>[] items, String[] labels, Integer[] images, Bundle bundle) {
        this.items = items;
        this.images = new HashMap();
        this.labels = new HashMap();
        this.known = new HashSet();
        this.restore(bundle, labels, images);
    }

    public void save(Bundle bundle) {
        for (int i = 0; i < this.items.length; ++i) {
            String itemName = this.items[i].toString();
            bundle.put(itemName + PFX_IMAGE, this.images.get(this.items[i]));
            bundle.put(itemName + PFX_LABEL, this.labels.get(this.items[i]));
            bundle.put(itemName + PFX_KNOWN, this.known.contains(this.items[i]));
        }
    }

    private void restore(Bundle bundle, String[] allLabels, Integer[] allImages) {
        ArrayList<String> labelsLeft = new ArrayList<String>(Arrays.asList(allLabels));
        ArrayList<Integer> imagesLeft = new ArrayList<Integer>(Arrays.asList(allImages));
        for (int i = 0; i < this.items.length; ++i) {
            Class<T> item = this.items[i];
            String itemName = item.toString();
            if (bundle.contains(itemName + PFX_LABEL)) {
                String label = bundle.getString(itemName + PFX_LABEL);
                this.labels.put(item, label);
                labelsLeft.remove(label);
                Integer image = bundle.getInt(itemName + PFX_IMAGE);
                this.images.put(item, image);
                imagesLeft.remove(image);
                if (!bundle.getBoolean(itemName + PFX_KNOWN)) continue;
                this.known.add(item);
                continue;
            }
            int index = Random.Int(labelsLeft.size());
            this.labels.put(item, labelsLeft.get(index));
            labelsLeft.remove(index);
            this.images.put(item, imagesLeft.get(index));
            imagesLeft.remove(index);
        }
    }

    public int image(T item) {
        return this.images.get(item.getClass());
    }

    public String label(T item) {
        return this.labels.get(item.getClass());
    }

    public boolean isKnown(T item) {
        return this.known.contains(item.getClass());
    }

    public void know(T item) {
        this.known.add(item.getClass());
        if (this.known.size() == this.items.length - 1) {
            for (int i = 0; i < this.items.length; ++i) {
                if (this.known.contains(this.items[i])) continue;
                this.known.add(this.items[i]);
                break;
            }
        }
    }

    public HashSet<Class<? extends T>> known() {
        return this.known;
    }

    public HashSet<Class<? extends T>> unknown() {
        HashSet<Class<T>> result = new HashSet<Class<T>>();
        for (Class<? extends T> i : this.items) {
            if (this.known.contains(i)) continue;
            result.add(i);
        }
        return result;
    }
}

