/*
 * Decompiled with CFR 0.152.
 */
package com.watabou.pixeldungeon.items;

import com.badlogic.gdx.utils.reflect.ClassReflection;
import com.watabou.noosa.audio.Sample;
import com.watabou.pixeldungeon.Badges;
import com.watabou.pixeldungeon.Dungeon;
import com.watabou.pixeldungeon.actors.Actor;
import com.watabou.pixeldungeon.actors.Char;
import com.watabou.pixeldungeon.actors.buffs.SnipersMark;
import com.watabou.pixeldungeon.actors.hero.Hero;
import com.watabou.pixeldungeon.effects.Speck;
import com.watabou.pixeldungeon.items.Generator;
import com.watabou.pixeldungeon.items.Heap;
import com.watabou.pixeldungeon.items.bags.Bag;
import com.watabou.pixeldungeon.items.weapon.missiles.MissileWeapon;
import com.watabou.pixeldungeon.mechanics.Ballistica;
import com.watabou.pixeldungeon.scenes.CellSelector;
import com.watabou.pixeldungeon.scenes.GameScene;
import com.watabou.pixeldungeon.sprites.ItemSprite;
import com.watabou.pixeldungeon.sprites.MissileSprite;
import com.watabou.pixeldungeon.ui.QuickSlot;
import com.watabou.pixeldungeon.utils.GLog;
import com.watabou.pixeldungeon.utils.Utils;
import com.watabou.utils.Bundlable;
import com.watabou.utils.Bundle;
import com.watabou.utils.Callback;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;

public class Item
implements Bundlable {
    private static final String TXT_PACK_FULL = "Your pack is too full for the %s";
    private static final String TXT_TO_STRING = "%s";
    private static final String TXT_TO_STRING_X = "%s x%d";
    private static final String TXT_TO_STRING_LVL = "%s%+d";
    private static final String TXT_TO_STRING_LVL_X = "%s%+d x%d";
    protected static final float TIME_TO_THROW = 1.0f;
    protected static final float TIME_TO_PICK_UP = 1.0f;
    protected static final float TIME_TO_DROP = 0.5f;
    public static final String AC_DROP = "DROP";
    public static final String AC_THROW = "THROW";
    public String defaultAction;
    protected String name = "smth";
    protected int image = 0;
    public boolean stackable = false;
    protected int quantity = 1;
    public int level = 0;
    public boolean levelKnown = false;
    public boolean cursed;
    public boolean cursedKnown;
    public boolean unique = false;
    private static Comparator<Item> itemComparator = new Comparator<Item>(){

        @Override
        public int compare(Item lhs, Item rhs) {
            return Generator.Category.order(lhs) - Generator.Category.order(rhs);
        }
    };
    private static final String QUANTITY = "quantity";
    private static final String LEVEL = "level";
    private static final String LEVEL_KNOWN = "levelKnown";
    private static final String CURSED = "cursed";
    private static final String CURSED_KNOWN = "cursedKnown";
    private static final String QUICKSLOT = "quickslot";
    protected static Hero curUser = null;
    protected static Item curItem = null;
    protected static CellSelector.Listener thrower = new CellSelector.Listener(){

        @Override
        public void onSelect(Integer target) {
            if (target != null) {
                curItem.cast(curUser, target);
            }
        }

        @Override
        public String prompt() {
            return "Choose direction of throw";
        }
    };

    public ArrayList<String> actions(Hero hero) {
        ArrayList<String> actions = new ArrayList<String>();
        actions.add(AC_DROP);
        actions.add(AC_THROW);
        return actions;
    }

    public boolean doPickUp(Hero hero) {
        if (this.collect(hero.belongings.backpack)) {
            GameScene.pickUp(this);
            Sample.INSTANCE.play("snd_item.mp3");
            hero.spendAndNext(1.0f);
            return true;
        }
        return false;
    }

    public void doDrop(Hero hero) {
        hero.spendAndNext(0.5f);
        Dungeon.level.drop((Item)this.detachAll((Bag)hero.belongings.backpack), (int)hero.pos).sprite.drop(hero.pos);
    }

    public void doThrow(Hero hero) {
        GameScene.selectCell(thrower);
    }

    public void execute(Hero hero, String action) {
        curUser = hero;
        curItem = this;
        if (action.equals(AC_DROP)) {
            this.doDrop(hero);
        } else if (action.equals(AC_THROW)) {
            this.doThrow(hero);
        }
    }

    public void execute(Hero hero) {
        this.execute(hero, this.defaultAction);
    }

    protected void onThrow(int cell) {
        Heap heap = Dungeon.level.drop(this, cell);
        if (!heap.isEmpty()) {
            heap.sprite.drop(cell);
        }
    }

    public boolean collect(Bag container) {
        ArrayList<Item> items = container.items;
        if (items.contains(this)) {
            return true;
        }
        for (Item item : items) {
            if (!(item instanceof Bag) || !((Bag)item).grab(this)) continue;
            return this.collect((Bag)item);
        }
        if (this.stackable) {
            Class<?> c = this.getClass();
            for (Item item : items) {
                if (item.getClass() != c) continue;
                item.quantity += this.quantity;
                item.updateQuickslot();
                return true;
            }
        }
        if (items.size() < container.size) {
            if (Dungeon.hero != null && Dungeon.hero.isAlive()) {
                Badges.validateItemLevelAquired(this);
            }
            items.add(this);
            QuickSlot.refresh();
            Collections.sort(items, itemComparator);
            return true;
        }
        GLog.n(Utils.format(TXT_PACK_FULL, this.name()), new Object[0]);
        return false;
    }

    public boolean collect() {
        return this.collect(Dungeon.hero.belongings.backpack);
    }

    public final Item detach(Bag container) {
        if (this.quantity <= 0) {
            return null;
        }
        if (this.quantity == 1) {
            return this.detachAll(container);
        }
        --this.quantity;
        this.updateQuickslot();
        try {
            Item detached = (Item)ClassReflection.newInstance(this.getClass());
            detached.onDetach();
            return detached;
        }
        catch (Exception e) {
            return null;
        }
    }

    public final Item detachAll(Bag container) {
        for (Item item : container.items) {
            Bag bag;
            if (item == this) {
                container.items.remove(this);
                item.onDetach();
                QuickSlot.refresh();
                return this;
            }
            if (!(item instanceof Bag) || !(bag = (Bag)item).contains(this)) continue;
            return this.detachAll(bag);
        }
        return this;
    }

    protected void onDetach() {
    }

    public Item upgrade() {
        this.cursed = false;
        this.cursedKnown = true;
        ++this.level;
        return this;
    }

    public Item upgrade(int n) {
        for (int i = 0; i < n; ++i) {
            this.upgrade();
        }
        return this;
    }

    public Item degrade() {
        --this.level;
        return this;
    }

    public Item degrade(int n) {
        for (int i = 0; i < n; ++i) {
            this.degrade();
        }
        return this;
    }

    public int visiblyUpgraded() {
        return this.levelKnown ? this.level : 0;
    }

    public boolean visiblyCursed() {
        return this.cursed && this.cursedKnown;
    }

    public boolean isUpgradable() {
        return true;
    }

    public boolean isIdentified() {
        return this.levelKnown && this.cursedKnown;
    }

    public boolean isEquipped(Hero hero) {
        return false;
    }

    public Item identify() {
        this.levelKnown = true;
        this.cursedKnown = true;
        return this;
    }

    public static void evoke(Hero hero) {
        hero.sprite.emitter().burst(Speck.factory(102), 5);
    }

    public String toString() {
        if (this.levelKnown && this.level != 0) {
            if (this.quantity > 1) {
                return Utils.format(TXT_TO_STRING_LVL_X, this.name(), this.level, this.quantity);
            }
            return Utils.format(TXT_TO_STRING_LVL, this.name(), this.level);
        }
        if (this.quantity > 1) {
            return Utils.format(TXT_TO_STRING_X, this.name(), this.quantity);
        }
        return Utils.format(TXT_TO_STRING, this.name());
    }

    public String name() {
        return this.name;
    }

    public final String trueName() {
        return this.name;
    }

    public int image() {
        return this.image;
    }

    public ItemSprite.Glowing glowing() {
        return null;
    }

    public String info() {
        return this.desc();
    }

    public String desc() {
        return "";
    }

    public int quantity() {
        return this.quantity;
    }

    public void quantity(int value) {
        this.quantity = value;
    }

    public int price() {
        return 0;
    }

    public static Item virtual(Class<? extends Item> cl) {
        try {
            Item item = ClassReflection.newInstance(cl);
            item.quantity = 0;
            return item;
        }
        catch (Exception e) {
            return null;
        }
    }

    public Item random() {
        return this;
    }

    public String status() {
        return this.quantity != 1 ? Integer.toString(this.quantity) : null;
    }

    public void updateQuickslot() {
        if (this.stackable && Dungeon.quickslot == this.getClass() || Dungeon.quickslot == this) {
            QuickSlot.refresh();
        }
    }

    @Override
    public void storeInBundle(Bundle bundle) {
        bundle.put(QUANTITY, this.quantity);
        bundle.put(LEVEL, this.level);
        bundle.put(LEVEL_KNOWN, this.levelKnown);
        bundle.put(CURSED, this.cursed);
        bundle.put(CURSED_KNOWN, this.cursedKnown);
        if (this == Dungeon.quickslot) {
            bundle.put(QUICKSLOT, true);
        }
    }

    @Override
    public void restoreFromBundle(Bundle bundle) {
        this.quantity = bundle.getInt(QUANTITY);
        this.levelKnown = bundle.getBoolean(LEVEL_KNOWN);
        this.cursedKnown = bundle.getBoolean(CURSED_KNOWN);
        int level = bundle.getInt(LEVEL);
        if (level > 0) {
            this.upgrade(level);
        } else if (level < 0) {
            this.degrade(-level);
        }
        this.cursed = bundle.getBoolean(CURSED);
        if (bundle.getBoolean(QUICKSLOT)) {
            Dungeon.quickslot = this;
        }
    }

    public void cast(final Hero user, int dst) {
        final int cell = Ballistica.cast(user.pos, dst, false, true);
        user.sprite.zap(cell);
        user.busy();
        Char enemy = Actor.findChar(cell);
        QuickSlot.target(this, enemy);
        float delay = 1.0f;
        if (this instanceof MissileWeapon) {
            delay *= ((MissileWeapon)this).speedFactor(user);
            if (enemy != null && enemy.buff(SnipersMark.class) != null) {
                delay *= 0.5f;
            }
        }
        final float finalDelay = delay;
        ((MissileSprite)user.sprite.parent.recycle(MissileSprite.class)).reset(user.pos, cell, this, new Callback(){

            @Override
            public void call() {
                Item.this.detach(user.belongings.backpack).onThrow(cell);
                user.spendAndNext(finalDelay);
            }
        });
    }
}

