/*
 * Decompiled with CFR 0.152.
 */
package com.watabou.pixeldungeon.items;

import com.badlogic.gdx.utils.reflect.ClassReflection;
import com.watabou.pixeldungeon.Dungeon;
import com.watabou.pixeldungeon.actors.mobs.npcs.Wandmaker;
import com.watabou.pixeldungeon.items.Gold;
import com.watabou.pixeldungeon.items.Item;
import com.watabou.pixeldungeon.items.armor.Armor;
import com.watabou.pixeldungeon.items.armor.ClothArmor;
import com.watabou.pixeldungeon.items.armor.LeatherArmor;
import com.watabou.pixeldungeon.items.armor.MailArmor;
import com.watabou.pixeldungeon.items.armor.PlateArmor;
import com.watabou.pixeldungeon.items.armor.ScaleArmor;
import com.watabou.pixeldungeon.items.bags.Bag;
import com.watabou.pixeldungeon.items.food.Food;
import com.watabou.pixeldungeon.items.food.MysteryMeat;
import com.watabou.pixeldungeon.items.food.Pasty;
import com.watabou.pixeldungeon.items.potions.Potion;
import com.watabou.pixeldungeon.items.potions.PotionOfExperience;
import com.watabou.pixeldungeon.items.potions.PotionOfFrost;
import com.watabou.pixeldungeon.items.potions.PotionOfHealing;
import com.watabou.pixeldungeon.items.potions.PotionOfInvisibility;
import com.watabou.pixeldungeon.items.potions.PotionOfLevitation;
import com.watabou.pixeldungeon.items.potions.PotionOfLiquidFlame;
import com.watabou.pixeldungeon.items.potions.PotionOfMight;
import com.watabou.pixeldungeon.items.potions.PotionOfMindVision;
import com.watabou.pixeldungeon.items.potions.PotionOfParalyticGas;
import com.watabou.pixeldungeon.items.potions.PotionOfPurity;
import com.watabou.pixeldungeon.items.potions.PotionOfStrength;
import com.watabou.pixeldungeon.items.potions.PotionOfToxicGas;
import com.watabou.pixeldungeon.items.rings.Ring;
import com.watabou.pixeldungeon.items.rings.RingOfAccuracy;
import com.watabou.pixeldungeon.items.rings.RingOfDetection;
import com.watabou.pixeldungeon.items.rings.RingOfElements;
import com.watabou.pixeldungeon.items.rings.RingOfEvasion;
import com.watabou.pixeldungeon.items.rings.RingOfHaggler;
import com.watabou.pixeldungeon.items.rings.RingOfHaste;
import com.watabou.pixeldungeon.items.rings.RingOfHerbalism;
import com.watabou.pixeldungeon.items.rings.RingOfMending;
import com.watabou.pixeldungeon.items.rings.RingOfPower;
import com.watabou.pixeldungeon.items.rings.RingOfSatiety;
import com.watabou.pixeldungeon.items.rings.RingOfShadows;
import com.watabou.pixeldungeon.items.rings.RingOfThorns;
import com.watabou.pixeldungeon.items.scrolls.Scroll;
import com.watabou.pixeldungeon.items.scrolls.ScrollOfChallenge;
import com.watabou.pixeldungeon.items.scrolls.ScrollOfIdentify;
import com.watabou.pixeldungeon.items.scrolls.ScrollOfLullaby;
import com.watabou.pixeldungeon.items.scrolls.ScrollOfMagicMapping;
import com.watabou.pixeldungeon.items.scrolls.ScrollOfMirrorImage;
import com.watabou.pixeldungeon.items.scrolls.ScrollOfPsionicBlast;
import com.watabou.pixeldungeon.items.scrolls.ScrollOfRecharging;
import com.watabou.pixeldungeon.items.scrolls.ScrollOfRemoveCurse;
import com.watabou.pixeldungeon.items.scrolls.ScrollOfTeleportation;
import com.watabou.pixeldungeon.items.scrolls.ScrollOfTerror;
import com.watabou.pixeldungeon.items.scrolls.ScrollOfUpgrade;
import com.watabou.pixeldungeon.items.scrolls.ScrollOfWeaponUpgrade;
import com.watabou.pixeldungeon.items.wands.Wand;
import com.watabou.pixeldungeon.items.wands.WandOfAmok;
import com.watabou.pixeldungeon.items.wands.WandOfAvalanche;
import com.watabou.pixeldungeon.items.wands.WandOfBlink;
import com.watabou.pixeldungeon.items.wands.WandOfDisintegration;
import com.watabou.pixeldungeon.items.wands.WandOfFirebolt;
import com.watabou.pixeldungeon.items.wands.WandOfFlock;
import com.watabou.pixeldungeon.items.wands.WandOfLightning;
import com.watabou.pixeldungeon.items.wands.WandOfMagicMissile;
import com.watabou.pixeldungeon.items.wands.WandOfPoison;
import com.watabou.pixeldungeon.items.wands.WandOfRegrowth;
import com.watabou.pixeldungeon.items.wands.WandOfSlowness;
import com.watabou.pixeldungeon.items.wands.WandOfTelekinesis;
import com.watabou.pixeldungeon.items.wands.WandOfTeleportation;
import com.watabou.pixeldungeon.items.weapon.Weapon;
import com.watabou.pixeldungeon.items.weapon.melee.BattleAxe;
import com.watabou.pixeldungeon.items.weapon.melee.Dagger;
import com.watabou.pixeldungeon.items.weapon.melee.Glaive;
import com.watabou.pixeldungeon.items.weapon.melee.Knuckles;
import com.watabou.pixeldungeon.items.weapon.melee.Longsword;
import com.watabou.pixeldungeon.items.weapon.melee.Mace;
import com.watabou.pixeldungeon.items.weapon.melee.Quarterstaff;
import com.watabou.pixeldungeon.items.weapon.melee.ShortSword;
import com.watabou.pixeldungeon.items.weapon.melee.Spear;
import com.watabou.pixeldungeon.items.weapon.melee.Sword;
import com.watabou.pixeldungeon.items.weapon.melee.WarHammer;
import com.watabou.pixeldungeon.items.weapon.missiles.Boomerang;
import com.watabou.pixeldungeon.items.weapon.missiles.CurareDart;
import com.watabou.pixeldungeon.items.weapon.missiles.Dart;
import com.watabou.pixeldungeon.items.weapon.missiles.IncendiaryDart;
import com.watabou.pixeldungeon.items.weapon.missiles.Javelin;
import com.watabou.pixeldungeon.items.weapon.missiles.Shuriken;
import com.watabou.pixeldungeon.items.weapon.missiles.Tamahawk;
import com.watabou.pixeldungeon.plants.Dreamweed;
import com.watabou.pixeldungeon.plants.Earthroot;
import com.watabou.pixeldungeon.plants.Fadeleaf;
import com.watabou.pixeldungeon.plants.Firebloom;
import com.watabou.pixeldungeon.plants.Icecap;
import com.watabou.pixeldungeon.plants.Plant;
import com.watabou.pixeldungeon.plants.Sorrowmoss;
import com.watabou.pixeldungeon.plants.Sungrass;
import com.watabou.utils.Random;
import java.util.HashMap;

public class Generator {
    private static HashMap<Category, Float> categoryProbs = new HashMap();

    public static void reset() {
        for (Category cat : Category.values()) {
            categoryProbs.put(cat, Float.valueOf(cat.prob));
        }
    }

    public static Item random() {
        return Generator.random(Random.chances(categoryProbs));
    }

    public static Item random(Category cat) {
        try {
            categoryProbs.put(cat, Float.valueOf(categoryProbs.get((Object)cat).floatValue() / 2.0f));
            switch (cat) {
                case ARMOR: {
                    return Generator.randomArmor();
                }
                case WEAPON: {
                    return Generator.randomWeapon();
                }
            }
            return ((Item)cat.classes[Random.chances(cat.probs)].newInstance()).random();
        }
        catch (Exception e) {
            return null;
        }
    }

    public static Item random(Class<? extends Item> cl) {
        try {
            return ClassReflection.newInstance(cl).random();
        }
        catch (Exception e) {
            return null;
        }
    }

    public static Armor randomArmor() throws Exception {
        int curStr = 10 + Dungeon.potionOfStrength;
        Category cat = Category.ARMOR;
        Armor a1 = (Armor)cat.classes[Random.chances(cat.probs)].newInstance();
        Armor a2 = (Armor)cat.classes[Random.chances(cat.probs)].newInstance();
        a1.random();
        a2.random();
        return Math.abs(curStr - a1.STR) < Math.abs(curStr - a2.STR) ? a1 : a2;
    }

    public static Weapon randomWeapon() throws Exception {
        int curStr = 10 + Dungeon.potionOfStrength;
        Category cat = Category.WEAPON;
        Weapon w1 = (Weapon)cat.classes[Random.chances(cat.probs)].newInstance();
        Weapon w2 = (Weapon)cat.classes[Random.chances(cat.probs)].newInstance();
        w1.random();
        w2.random();
        return Math.abs(curStr - w1.STR) < Math.abs(curStr - w2.STR) ? w1 : w2;
    }

    static {
        Category.GOLD.classes = new Class[]{Gold.class};
        Category.GOLD.probs = new float[]{1.0f};
        Category.SCROLL.classes = new Class[]{ScrollOfIdentify.class, ScrollOfTeleportation.class, ScrollOfRemoveCurse.class, ScrollOfUpgrade.class, ScrollOfRecharging.class, ScrollOfMagicMapping.class, ScrollOfChallenge.class, ScrollOfTerror.class, ScrollOfLullaby.class, ScrollOfWeaponUpgrade.class, ScrollOfPsionicBlast.class, ScrollOfMirrorImage.class};
        Category.SCROLL.probs = new float[]{30.0f, 10.0f, 15.0f, 0.0f, 10.0f, 15.0f, 12.0f, 8.0f, 8.0f, 0.0f, 4.0f, 6.0f};
        Category.POTION.classes = new Class[]{PotionOfHealing.class, PotionOfExperience.class, PotionOfToxicGas.class, PotionOfParalyticGas.class, PotionOfLiquidFlame.class, PotionOfLevitation.class, PotionOfStrength.class, PotionOfMindVision.class, PotionOfPurity.class, PotionOfInvisibility.class, PotionOfMight.class, PotionOfFrost.class};
        Category.POTION.probs = new float[]{45.0f, 4.0f, 15.0f, 10.0f, 15.0f, 10.0f, 0.0f, 20.0f, 12.0f, 10.0f, 0.0f, 10.0f};
        Category.WAND.classes = new Class[]{WandOfTeleportation.class, WandOfSlowness.class, WandOfFirebolt.class, WandOfRegrowth.class, WandOfPoison.class, WandOfBlink.class, WandOfLightning.class, WandOfAmok.class, WandOfTelekinesis.class, WandOfFlock.class, WandOfMagicMissile.class, WandOfDisintegration.class, WandOfAvalanche.class};
        Category.WAND.probs = new float[]{10.0f, 10.0f, 15.0f, 6.0f, 10.0f, 11.0f, 15.0f, 10.0f, 6.0f, 10.0f, 0.0f, 5.0f, 5.0f};
        Category.WEAPON.classes = new Class[]{Dagger.class, Knuckles.class, Quarterstaff.class, Spear.class, Mace.class, Sword.class, Longsword.class, BattleAxe.class, WarHammer.class, Glaive.class, ShortSword.class, Dart.class, Javelin.class, IncendiaryDart.class, CurareDart.class, Shuriken.class, Boomerang.class, Tamahawk.class};
        Category.WEAPON.probs = new float[]{1.0f, 1.0f, 1.0f, 1.0f, 1.0f, 1.0f, 1.0f, 1.0f, 1.0f, 1.0f, 0.0f, 0.0f, 1.0f, 1.0f, 1.0f, 1.0f, 0.0f, 1.0f};
        Category.ARMOR.classes = new Class[]{ClothArmor.class, LeatherArmor.class, MailArmor.class, ScaleArmor.class, PlateArmor.class};
        Category.ARMOR.probs = new float[]{1.0f, 1.0f, 1.0f, 1.0f, 1.0f};
        Category.FOOD.classes = new Class[]{Food.class, Pasty.class, MysteryMeat.class};
        Category.FOOD.probs = new float[]{4.0f, 1.0f, 0.0f};
        Category.RING.classes = new Class[]{RingOfMending.class, RingOfDetection.class, RingOfShadows.class, RingOfPower.class, RingOfHerbalism.class, RingOfAccuracy.class, RingOfEvasion.class, RingOfSatiety.class, RingOfHaste.class, RingOfElements.class, RingOfHaggler.class, RingOfThorns.class};
        Category.RING.probs = new float[]{1.0f, 1.0f, 1.0f, 1.0f, 1.0f, 1.0f, 1.0f, 1.0f, 1.0f, 1.0f, 0.0f, 0.0f};
        Category.SEED.classes = new Class[]{Firebloom.Seed.class, Icecap.Seed.class, Sorrowmoss.Seed.class, Dreamweed.Seed.class, Sungrass.Seed.class, Earthroot.Seed.class, Fadeleaf.Seed.class, Wandmaker.Rotberry.Seed.class};
        Category.SEED.probs = new float[]{1.0f, 1.0f, 1.0f, 1.0f, 1.0f, 1.0f, 1.0f, 0.0f};
    }

    public static enum Category {
        WEAPON(15.0f, Weapon.class),
        ARMOR(10.0f, Armor.class),
        POTION(50.0f, Potion.class),
        SCROLL(40.0f, Scroll.class),
        WAND(4.0f, Wand.class),
        RING(2.0f, Ring.class),
        SEED(5.0f, Plant.Seed.class),
        FOOD(0.0f, Food.class),
        GOLD(50.0f, Gold.class);

        public Class<?>[] classes;
        public float[] probs;
        public float prob;
        public Class<? extends Item> superClass;

        private Category(float prob, Class<? extends Item> superClass) {
            this.prob = prob;
            this.superClass = superClass;
        }

        public static int order(Item item) {
            for (int i = 0; i < Category.values().length; ++i) {
                if (!Category.values()[i].superClass.isInstance(item)) continue;
                return i;
            }
            return item instanceof Bag ? Integer.MAX_VALUE : 0x7FFFFFFE;
        }
    }
}

