/*
 * Decompiled with CFR 0.152.
 */
package com.watabou.pixeldungeon.effects.particles;

import com.watabou.noosa.Game;
import com.watabou.noosa.Group;
import com.watabou.noosa.particles.Emitter;
import com.watabou.noosa.particles.PixelParticle;
import com.watabou.pixeldungeon.Dungeon;
import com.watabou.pixeldungeon.DungeonTilemap;
import com.watabou.utils.PointF;
import com.watabou.utils.Random;

public class FlowParticle
extends PixelParticle {
    public static final Emitter.Factory FACTORY = new Emitter.Factory(){

        @Override
        public void emit(Emitter emitter, int index, float x, float y) {
            ((FlowParticle)emitter.recycle(FlowParticle.class)).reset(x, y);
        }
    };

    public FlowParticle() {
        this.lifespan = 0.6f;
        this.acc.set(0.0f, 32.0f);
        this.angularSpeed = Random.Float(-360.0f, 360.0f);
    }

    public void reset(float x, float y) {
        this.revive();
        this.left = this.lifespan;
        this.x = x;
        this.y = y;
        this.am = 0.0f;
        this.size(0.0f);
        this.speed.set(0.0f);
    }

    @Override
    public void update() {
        super.update();
        float p = this.left / this.lifespan;
        this.am = (p < 0.5f ? p : 1.0f - p) * 0.6f;
        this.size((1.0f - p) * 4.0f);
    }

    public static class Flow
    extends Group {
        private static final float DELAY = 0.1f;
        private int pos;
        private float x;
        private float y;
        private float delay;

        public Flow(int pos) {
            this.pos = pos;
            PointF p = DungeonTilemap.tileToWorld(pos);
            this.x = p.x;
            this.y = p.y + 16.0f - 1.0f;
            this.delay = Random.Float(0.1f);
        }

        @Override
        public void update() {
            this.visible = Dungeon.visible[this.pos];
            if (this.visible) {
                float f;
                super.update();
                this.delay -= Game.elapsed;
                if (f <= 0.0f) {
                    this.delay = Random.Float(0.1f);
                    ((FlowParticle)this.recycle(FlowParticle.class)).reset(this.x + Random.Float(16.0f), this.y);
                }
            }
        }
    }
}

