/*
 * Decompiled with CFR 0.152.
 */
package com.watabou.pixeldungeon.effects.particles;

import com.watabou.noosa.particles.Emitter;
import com.watabou.noosa.particles.PixelParticle;
import com.watabou.utils.ColorMath;
import com.watabou.utils.Random;

public class EarthParticle
extends PixelParticle {
    public static final Emitter.Factory FACTORY = new Emitter.Factory(){

        @Override
        public void emit(Emitter emitter, int index, float x, float y) {
            ((EarthParticle)emitter.recycle(EarthParticle.class)).reset(x, y);
        }
    };

    public EarthParticle() {
        this.color(ColorMath.random(0x444444, 0x777766));
        this.angle = Random.Float(-30.0f, 30.0f);
        this.lifespan = 0.5f;
    }

    public void reset(float x, float y) {
        this.revive();
        this.x = x;
        this.y = y;
        this.left = this.lifespan;
    }

    @Override
    public void update() {
        super.update();
        float p = this.left / this.lifespan;
        this.size((p < 0.5f ? p : 1.0f - p) * 16.0f);
    }
}

