/*
 * Decompiled with CFR 0.152.
 */
package com.watabou.pixeldungeon.effects.particles;

import com.watabou.noosa.particles.Emitter;
import com.watabou.noosa.particles.PixelParticle;

public class BloodParticle
extends PixelParticle.Shrinking {
    public static final Emitter.Factory FACTORY = new Emitter.Factory(){

        @Override
        public void emit(Emitter emitter, int index, float x, float y) {
            ((BloodParticle)emitter.recycle(BloodParticle.class)).reset(x, y);
        }
    };

    public BloodParticle() {
        this.color(0xCC0000);
        this.lifespan = 0.8f;
        this.acc.set(0.0f, 40.0f);
    }

    public void reset(float x, float y) {
        this.revive();
        this.x = x;
        this.y = y;
        this.left = this.lifespan;
        this.size = 4.0f;
        this.speed.set(0.0f);
    }

    @Override
    public void update() {
        super.update();
        float p = this.left / this.lifespan;
        this.am = p > 0.6f ? (1.0f - p) * 2.5f : 1.0f;
    }
}

