/*
 * Decompiled with CFR 0.152.
 */
package com.watabou.pixeldungeon.effects;

import com.watabou.noosa.Game;
import com.watabou.noosa.Group;
import com.watabou.noosa.Image;
import com.watabou.pixeldungeon.Dungeon;
import com.watabou.pixeldungeon.actors.Char;
import com.watabou.pixeldungeon.effects.Effects;

public class Wound
extends Image {
    private static final float TIME_TO_FADE = 0.8f;
    private float time;

    public Wound() {
        super(Effects.get(Effects.Type.WOUND));
        this.origin.set(this.width / 2.0f, this.height / 2.0f);
    }

    public void reset(int p) {
        this.revive();
        this.x = (float)(p % 32 * 16) + (16.0f - this.width) / 2.0f;
        this.y = (float)(p / 32 * 16) + (16.0f - this.height) / 2.0f;
        this.time = 0.8f;
    }

    @Override
    public void update() {
        float f;
        super.update();
        this.time -= Game.elapsed;
        if (f <= 0.0f) {
            this.kill();
        } else {
            float p = this.time / 0.8f;
            this.alpha(p);
            this.scale.x = 1.0f + p;
        }
    }

    public static void hit(Char ch) {
        Wound.hit(ch, 0.0f);
    }

    public static void hit(Char ch, float angle) {
        Wound w = (Wound)ch.sprite.parent.recycle(Wound.class);
        ch.sprite.parent.bringToFront(w);
        w.reset(ch.pos);
        w.angle = angle;
    }

    public static void hit(int pos) {
        Wound.hit(pos, 0.0f);
    }

    public static void hit(int pos, float angle) {
        Group parent = Dungeon.hero.sprite.parent;
        Wound w = (Wound)parent.recycle(Wound.class);
        parent.bringToFront(w);
        w.reset(pos);
        w.angle = angle;
    }
}

