/*
 * Decompiled with CFR 0.152.
 */
package com.watabou.pixeldungeon.effects;

import com.badlogic.gdx.Gdx;
import com.watabou.noosa.Game;
import com.watabou.pixeldungeon.effects.Halo;
import com.watabou.pixeldungeon.sprites.CharSprite;

public class TorchHalo
extends Halo {
    private CharSprite target;
    private float phase = 0.0f;

    public TorchHalo(CharSprite sprite) {
        super(24.0f, 0xFFDDCC, 0.15f);
        this.target = sprite;
        this.am = 0.0f;
    }

    @Override
    public void update() {
        super.update();
        if (this.phase < 0.0f) {
            float f;
            this.phase += Game.elapsed;
            if (f >= 0.0f) {
                this.killAndErase();
            } else {
                this.scale.set((2.0f + this.phase) * this.radius / 64.0f);
                this.am = -this.phase * this.brightness;
            }
        } else if (this.phase < 1.0f) {
            float f;
            this.phase += Game.elapsed;
            if (f >= 1.0f) {
                this.phase = 1.0f;
            }
            this.scale.set(this.phase * this.radius / 64.0f);
            this.am = this.phase * this.brightness;
        }
        this.point(this.target.x + this.target.width / 2.0f, this.target.y + this.target.height / 2.0f);
    }

    @Override
    public void draw() {
        Gdx.gl.glBlendFunc(770, 1);
        super.draw();
        Gdx.gl.glBlendFunc(770, 771);
    }

    public void putOut() {
        this.phase = -1.0f;
    }
}

