/*
 * Decompiled with CFR 0.152.
 */
package com.watabou.pixeldungeon.effects;

import com.watabou.noosa.Game;
import com.watabou.noosa.Visual;
import com.watabou.pixeldungeon.actors.Actor;
import com.watabou.pixeldungeon.actors.Char;
import com.watabou.pixeldungeon.sprites.CharSprite;
import com.watabou.utils.PointF;

public class Pushing
extends Actor {
    private CharSprite sprite;
    private int from;
    private int to;
    private Effect effect;

    public Pushing(Char ch, int from, int to) {
        this.sprite = ch.sprite;
        this.from = from;
        this.to = to;
    }

    @Override
    protected boolean act() {
        if (this.sprite != null) {
            if (this.effect == null) {
                new Effect();
            }
            return false;
        }
        Actor.remove(this);
        return true;
    }

    public class Effect
    extends Visual {
        private static final float DELAY = 0.15f;
        private PointF end;
        private float delay;

        public Effect() {
            super(0.0f, 0.0f, 0.0f, 0.0f);
            this.point(Pushing.this.sprite.worldToCamera(Pushing.this.from));
            this.end = Pushing.this.sprite.worldToCamera(Pushing.this.to);
            this.speed.set(2.0f * (this.end.x - this.x) / 0.15f, 2.0f * (this.end.y - this.y) / 0.15f);
            this.acc.set(-this.speed.x / 0.15f, -this.speed.y / 0.15f);
            this.delay = 0.0f;
            ((Pushing)Pushing.this).sprite.parent.add(this);
        }

        @Override
        public void update() {
            float f;
            super.update();
            this.delay += Game.elapsed;
            if (f < 0.15f) {
                ((Pushing)Pushing.this).sprite.x = this.x;
                ((Pushing)Pushing.this).sprite.y = this.y;
            } else {
                Pushing.this.sprite.point(this.end);
                this.killAndErase();
                Actor.remove(Pushing.this);
                Pushing.this.next();
            }
        }
    }
}

