/*
 * Decompiled with CFR 0.152.
 */
package com.watabou.pixeldungeon.effects;

import com.watabou.noosa.Game;
import com.watabou.noosa.Group;
import com.watabou.noosa.particles.Emitter;
import com.watabou.noosa.particles.PixelParticle;
import com.watabou.pixeldungeon.DungeonTilemap;
import com.watabou.pixeldungeon.effects.particles.FlameParticle;
import com.watabou.pixeldungeon.effects.particles.LeafParticle;
import com.watabou.pixeldungeon.effects.particles.PoisonParticle;
import com.watabou.pixeldungeon.effects.particles.PurpleParticle;
import com.watabou.pixeldungeon.effects.particles.ShadowParticle;
import com.watabou.pixeldungeon.effects.particles.WoolParticle;
import com.watabou.utils.Callback;
import com.watabou.utils.ColorMath;
import com.watabou.utils.PointF;
import com.watabou.utils.Random;

public class MagicMissile
extends Emitter {
    private static final float SPEED = 200.0f;
    private Callback callback;
    private float sx;
    private float sy;
    private float time;

    public void reset(int from, int to, Callback callback) {
        this.callback = callback;
        this.revive();
        PointF pf = DungeonTilemap.tileCenterToWorld(from);
        PointF pt = DungeonTilemap.tileCenterToWorld(to);
        this.x = pf.x;
        this.y = pf.y;
        this.width = 0.0f;
        this.height = 0.0f;
        PointF d = PointF.diff(pt, pf);
        PointF speed = new PointF(d).normalize().scale(200.0f);
        this.sx = speed.x;
        this.sy = speed.y;
        this.time = d.length() / 200.0f;
    }

    public void size(float size) {
        this.x -= size / 2.0f;
        this.y -= size / 2.0f;
        this.width = this.height = size;
    }

    public static void blueLight(Group group, int from, int to, Callback callback) {
        MagicMissile missile = (MagicMissile)group.recycle(MagicMissile.class);
        missile.reset(from, to, callback);
        missile.pour(MagicParticle.FACTORY, 0.01f);
    }

    public static void fire(Group group, int from, int to, Callback callback) {
        MagicMissile missile = (MagicMissile)group.recycle(MagicMissile.class);
        missile.reset(from, to, callback);
        missile.size(4.0f);
        missile.pour(FlameParticle.FACTORY, 0.01f);
    }

    public static void earth(Group group, int from, int to, Callback callback) {
        MagicMissile missile = (MagicMissile)group.recycle(MagicMissile.class);
        missile.reset(from, to, callback);
        missile.size(2.0f);
        missile.pour(EarthParticle.FACTORY, 0.01f);
    }

    public static void purpleLight(Group group, int from, int to, Callback callback) {
        MagicMissile missile = (MagicMissile)group.recycle(MagicMissile.class);
        missile.reset(from, to, callback);
        missile.size(2.0f);
        missile.pour(PurpleParticle.MISSILE, 0.01f);
    }

    public static void whiteLight(Group group, int from, int to, Callback callback) {
        MagicMissile missile = (MagicMissile)group.recycle(MagicMissile.class);
        missile.reset(from, to, callback);
        missile.size(4.0f);
        missile.pour(WhiteParticle.FACTORY, 0.01f);
    }

    public static void wool(Group group, int from, int to, Callback callback) {
        MagicMissile missile = (MagicMissile)group.recycle(MagicMissile.class);
        missile.reset(from, to, callback);
        missile.size(3.0f);
        missile.pour(WoolParticle.FACTORY, 0.01f);
    }

    public static void poison(Group group, int from, int to, Callback callback) {
        MagicMissile missile = (MagicMissile)group.recycle(MagicMissile.class);
        missile.reset(from, to, callback);
        missile.size(3.0f);
        missile.pour(PoisonParticle.MISSILE, 0.01f);
    }

    public static void foliage(Group group, int from, int to, Callback callback) {
        MagicMissile missile = (MagicMissile)group.recycle(MagicMissile.class);
        missile.reset(from, to, callback);
        missile.size(4.0f);
        missile.pour(LeafParticle.GENERAL, 0.01f);
    }

    public static void slowness(Group group, int from, int to, Callback callback) {
        MagicMissile missile = (MagicMissile)group.recycle(MagicMissile.class);
        missile.reset(from, to, callback);
        missile.pour(SlowParticle.FACTORY, 0.01f);
    }

    public static void force(Group group, int from, int to, Callback callback) {
        MagicMissile missile = (MagicMissile)group.recycle(MagicMissile.class);
        missile.reset(from, to, callback);
        missile.size(4.0f);
        missile.pour(ForceParticle.FACTORY, 0.01f);
    }

    public static void coldLight(Group group, int from, int to, Callback callback) {
        MagicMissile missile = (MagicMissile)group.recycle(MagicMissile.class);
        missile.reset(from, to, callback);
        missile.size(4.0f);
        missile.pour(ColdParticle.FACTORY, 0.01f);
    }

    public static void shadow(Group group, int from, int to, Callback callback) {
        MagicMissile missile = (MagicMissile)group.recycle(MagicMissile.class);
        missile.reset(from, to, callback);
        missile.size(4.0f);
        missile.pour(ShadowParticle.MISSILE, 0.01f);
    }

    @Override
    public void update() {
        super.update();
        if (this.on) {
            float f;
            float d = Game.elapsed;
            this.x += this.sx * d;
            this.y += this.sy * d;
            this.time -= d;
            if (f <= 0.0f) {
                this.on = false;
                this.callback.call();
            }
        }
    }

    public static class ColdParticle
    extends PixelParticle.Shrinking {
        public static final Emitter.Factory FACTORY = new Emitter.Factory(){

            @Override
            public void emit(Emitter emitter, int index, float x, float y) {
                ((ColdParticle)emitter.recycle(ColdParticle.class)).reset(x, y);
            }

            @Override
            public boolean lightMode() {
                return true;
            }
        };

        public ColdParticle() {
            this.lifespan = 0.6f;
            this.color(0x2244FF);
        }

        public void reset(float x, float y) {
            this.revive();
            this.x = x;
            this.y = y;
            this.left = this.lifespan;
            this.size = 8.0f;
        }

        @Override
        public void update() {
            super.update();
            this.am = 1.0f - this.left / this.lifespan;
        }
    }

    public static class ForceParticle
    extends PixelParticle {
        public static final Emitter.Factory FACTORY = new Emitter.Factory(){

            @Override
            public void emit(Emitter emitter, int index, float x, float y) {
                ((ForceParticle)emitter.recycle(ForceParticle.class)).reset(x, y);
            }
        };

        public ForceParticle() {
            this.lifespan = 0.6f;
            this.size(4.0f);
        }

        public void reset(float x, float y) {
            this.revive();
            this.x = x;
            this.y = y;
            this.left = this.lifespan;
            this.acc.set(0.0f);
            this.speed.set(Random.Float(-40.0f, 40.0f), Random.Float(-40.0f, 40.0f));
        }

        @Override
        public void update() {
            super.update();
            this.am = this.left / this.lifespan / 2.0f;
            this.acc.set(-this.speed.x * 10.0f, -this.speed.y * 10.0f);
        }
    }

    public static class SlowParticle
    extends PixelParticle {
        private Emitter emitter;
        public static final Emitter.Factory FACTORY = new Emitter.Factory(){

            @Override
            public void emit(Emitter emitter, int index, float x, float y) {
                ((SlowParticle)emitter.recycle(SlowParticle.class)).reset(x, y, emitter);
            }

            @Override
            public boolean lightMode() {
                return true;
            }
        };

        public SlowParticle() {
            this.lifespan = 0.6f;
            this.color(0x664422);
            this.size(2.0f);
        }

        public void reset(float x, float y, Emitter emitter) {
            this.revive();
            this.x = x;
            this.y = y;
            this.emitter = emitter;
            this.left = this.lifespan;
            this.acc.set(0.0f);
            this.speed.set(Random.Float(-20.0f, 20.0f), Random.Float(-20.0f, 20.0f));
        }

        @Override
        public void update() {
            super.update();
            this.am = this.left / this.lifespan;
            this.acc.set((this.emitter.x - this.x) * 10.0f, (this.emitter.y - this.y) * 10.0f);
        }
    }

    public static class WhiteParticle
    extends PixelParticle {
        public static final Emitter.Factory FACTORY = new Emitter.Factory(){

            @Override
            public void emit(Emitter emitter, int index, float x, float y) {
                ((WhiteParticle)emitter.recycle(WhiteParticle.class)).reset(x, y);
            }

            @Override
            public boolean lightMode() {
                return true;
            }
        };

        public WhiteParticle() {
            this.lifespan = 0.4f;
            this.am = 0.5f;
        }

        public void reset(float x, float y) {
            this.revive();
            this.x = x;
            this.y = y;
            this.left = this.lifespan;
        }

        @Override
        public void update() {
            super.update();
            this.size(this.left / this.lifespan * 3.0f);
        }
    }

    public static class EarthParticle
    extends PixelParticle.Shrinking {
        public static final Emitter.Factory FACTORY = new Emitter.Factory(){

            @Override
            public void emit(Emitter emitter, int index, float x, float y) {
                ((EarthParticle)emitter.recycle(EarthParticle.class)).reset(x, y);
            }
        };

        public EarthParticle() {
            this.lifespan = 0.5f;
            this.color(ColorMath.random(0x555555, 0x777766));
            this.acc.set(0.0f, 40.0f);
        }

        public void reset(float x, float y) {
            this.revive();
            this.x = x;
            this.y = y;
            this.left = this.lifespan;
            this.size = 4.0f;
            this.speed.set(Random.Float(-10.0f, 10.0f), Random.Float(-10.0f, 10.0f));
        }
    }

    public static class MagicParticle
    extends PixelParticle {
        public static final Emitter.Factory FACTORY = new Emitter.Factory(){

            @Override
            public void emit(Emitter emitter, int index, float x, float y) {
                ((MagicParticle)emitter.recycle(MagicParticle.class)).reset(x, y);
            }

            @Override
            public boolean lightMode() {
                return true;
            }
        };

        public MagicParticle() {
            this.color(0x88CCFF);
            this.lifespan = 0.5f;
            this.speed.set(Random.Float(-10.0f, 10.0f), Random.Float(-10.0f, 10.0f));
        }

        public void reset(float x, float y) {
            this.revive();
            this.x = x;
            this.y = y;
            this.left = this.lifespan;
        }

        @Override
        public void update() {
            super.update();
            this.am = this.left / this.lifespan;
            this.size(4.0f - this.am * 3.0f);
        }
    }
}

