/*
 * Decompiled with CFR 0.152.
 */
package com.watabou.pixeldungeon.effects;

import com.badlogic.gdx.Gdx;
import com.watabou.noosa.Game;
import com.watabou.noosa.Group;
import com.watabou.noosa.Image;
import com.watabou.noosa.audio.Sample;
import com.watabou.pixeldungeon.effects.Effects;
import com.watabou.utils.Callback;
import com.watabou.utils.Random;

public class Lightning
extends Group {
    private static final float DURATION = 0.3f;
    private float life;
    private int length;
    private float[] cx;
    private float[] cy;
    private Image[] arcsS;
    private Image[] arcsE;
    private Callback callback;
    private static final double A = 57.29577951308232;

    public Lightning(int[] cells, int length, Callback callback) {
        int i;
        this.callback = callback;
        Image proto = Effects.get(Effects.Type.LIGHTNING);
        float ox = 0.0f;
        float oy = proto.height / 2.0f;
        this.length = length;
        this.cx = new float[length];
        this.cy = new float[length];
        for (i = 0; i < length; ++i) {
            int c = cells[i];
            this.cx[i] = ((float)(c % 32) + 0.5f) * 16.0f;
            this.cy[i] = ((float)(c / 32) + 0.5f) * 16.0f;
        }
        this.arcsS = new Image[length - 1];
        this.arcsE = new Image[length - 1];
        for (i = 0; i < length - 1; ++i) {
            Image arc = this.arcsS[i] = new Image(proto);
            arc.x = this.cx[i] - arc.origin.x;
            arc.y = this.cy[i] - arc.origin.y;
            arc.origin.set(ox, oy);
            this.add(arc);
            arc = this.arcsE[i] = new Image(proto);
            arc.origin.set(ox, oy);
            this.add(arc);
        }
        this.life = 0.3f;
        Sample.INSTANCE.play("snd_lightning.mp3");
    }

    @Override
    public void update() {
        float f;
        super.update();
        this.life -= Game.elapsed;
        if (f < 0.0f) {
            this.killAndErase();
            if (this.callback != null) {
                this.callback.call();
            }
        } else {
            float alpha = this.life / 0.3f;
            for (int i = 0; i < this.length - 1; ++i) {
                float sx = this.cx[i];
                float sy = this.cy[i];
                float ex = this.cx[i + 1];
                float ey = this.cy[i + 1];
                float x2 = (sx + ex) / 2.0f + Random.Float(-4.0f, 4.0f);
                float y2 = (sy + ey) / 2.0f + Random.Float(-4.0f, 4.0f);
                float dx = x2 - sx;
                float dy = y2 - sy;
                Image arc = this.arcsS[i];
                arc.am = alpha;
                arc.angle = (float)(Math.atan2(dy, dx) * 57.29577951308232);
                arc.scale.x = (float)Math.sqrt(dx * dx + dy * dy) / arc.width;
                dx = ex - x2;
                dy = ey - y2;
                arc = this.arcsE[i];
                arc.am = alpha;
                arc.angle = (float)(Math.atan2(dy, dx) * 57.29577951308232);
                arc.scale.x = (float)Math.sqrt(dx * dx + dy * dy) / arc.width;
                arc.x = x2 - arc.origin.x;
                arc.y = y2 - arc.origin.x;
            }
        }
    }

    @Override
    public void draw() {
        Gdx.gl.glBlendFunc(770, 1);
        super.draw();
        Gdx.gl.glBlendFunc(770, 771);
    }
}

