/*
 * Decompiled with CFR 0.152.
 */
package com.watabou.pixeldungeon.effects;

import com.badlogic.gdx.graphics.Pixmap;
import com.watabou.gdx.GdxTexture;
import com.watabou.gltextures.SmartTexture;
import com.watabou.gltextures.TextureCache;
import com.watabou.noosa.Image;

public class Halo
extends Image {
    private static final Object CACHE_KEY = Halo.class;
    protected static final int RADIUS = 64;
    protected float radius = 64.0f;
    protected float brightness = 1.0f;

    public Halo() {
        if (!TextureCache.contains(CACHE_KEY)) {
            Pixmap pixmap = new Pixmap(128, 128, Pixmap.Format.RGBA8888);
            pixmap.setColor(-1);
            pixmap.fillCircle(64, 64, 48);
            pixmap.setColor(-120);
            pixmap.fillCircle(64, 64, 64);
            GdxTexture bmp = new GdxTexture(pixmap);
            TextureCache.add(CACHE_KEY, new SmartTexture(bmp));
        }
        this.texture(CACHE_KEY);
        this.origin.set(64.0f);
    }

    public Halo(float radius, int color, float brightness) {
        this();
        this.hardlight(color);
        this.brightness = brightness;
        this.alpha(this.brightness);
        this.radius(radius);
    }

    public Halo point(float x, float y) {
        this.x = x - 64.0f;
        this.y = y - 64.0f;
        return this;
    }

    public void radius(float value) {
        this.radius = value;
        this.scale.set(this.radius / 64.0f);
    }
}

