/*
 * Decompiled with CFR 0.152.
 */
package com.watabou.pixeldungeon.effects;

import com.watabou.noosa.BitmapText;
import com.watabou.noosa.Camera;
import com.watabou.noosa.Game;
import com.watabou.pixeldungeon.scenes.GameScene;
import com.watabou.pixeldungeon.scenes.PixelScene;
import com.watabou.utils.SparseArray;
import java.util.ArrayList;

public class FloatingText
extends BitmapText {
    private static final float LIFESPAN = 1.0f;
    private static final float DISTANCE = 16.0f;
    private float timeLeft;
    private int key = -1;
    private float cameraZoom = -1.0f;
    private static SparseArray<ArrayList<FloatingText>> stacks = new SparseArray();

    public FloatingText() {
        this.speed.y = -16.0f;
    }

    @Override
    public void update() {
        super.update();
        if (this.timeLeft > 0.0f) {
            float f;
            this.timeLeft -= Game.elapsed;
            if (f <= 0.0f) {
                this.kill();
            } else {
                float p = this.timeLeft / 1.0f;
                this.alpha(p > 0.5f ? 1.0f : p * 2.0f);
            }
        }
    }

    @Override
    public void kill() {
        if (this.key != -1) {
            ((ArrayList)stacks.get(this.key)).remove(this);
            this.key = -1;
        }
        super.kill();
    }

    @Override
    public void destroy() {
        this.kill();
        super.destroy();
    }

    public void reset(float x, float y, String text, int color) {
        this.revive();
        if (this.cameraZoom != Camera.main.zoom) {
            this.cameraZoom = Camera.main.zoom;
            PixelScene.chooseFont(9.0f, this.cameraZoom);
            this.font = PixelScene.font;
            this.scale.set(PixelScene.scale);
        }
        this.text(text);
        this.hardlight(color);
        this.measure();
        this.x = PixelScene.align(x - this.width() / 2.0f);
        this.y = y - this.height();
        this.timeLeft = 1.0f;
    }

    public static void show(float x, float y, String text, int color) {
        GameScene.status().reset(x, y, text, color);
    }

    public static void show(float x, float y, int key, String text, int color) {
        FloatingText txt = GameScene.status();
        txt.reset(x, y, text, color);
        FloatingText.push(txt, key);
    }

    private static void push(FloatingText txt, int key) {
        txt.key = key;
        ArrayList<FloatingText> stack = (ArrayList<FloatingText>)stacks.get(key);
        if (stack == null) {
            stack = new ArrayList<FloatingText>();
            stacks.put(key, stack);
        }
        if (stack.size() > 0) {
            FloatingText above;
            FloatingText below = txt;
            for (int aboveIndex = stack.size() - 1; aboveIndex >= 0 && above.y + (above = (FloatingText)stack.get(aboveIndex)).height() > below.y; --aboveIndex) {
                above.y = below.y - above.height();
                below = above;
            }
        }
        stack.add(txt);
    }
}

