/*
 * Decompiled with CFR 0.152.
 */
package com.watabou.pixeldungeon.effects;

import com.badlogic.gdx.Gdx;
import com.badlogic.gdx.graphics.Texture;
import com.watabou.noosa.Game;
import com.watabou.noosa.Group;
import com.watabou.noosa.Image;
import com.watabou.noosa.particles.Emitter;
import com.watabou.noosa.particles.PixelParticle;
import com.watabou.noosa.ui.Component;
import com.watabou.utils.ColorMath;
import com.watabou.utils.Random;
import com.watabou.utils.RectF;

public class Fireball
extends Component {
    private static final RectF BLIGHT = new RectF(0.0f, 0.0f, 0.25f, 1.0f);
    private static final RectF FLIGHT = new RectF(0.25f, 0.0f, 0.5f, 1.0f);
    private static final RectF FLAME1 = new RectF(0.5f, 0.0f, 0.75f, 1.0f);
    private static final RectF FLAME2 = new RectF(0.75f, 0.0f, 1.0f, 1.0f);
    private static final int COLOR = 0xFF66FF;
    private Image bLight;
    private Image fLight;
    private Emitter emitter;
    private Group sparks;

    @Override
    protected void createChildren() {
        this.sparks = new Group();
        this.add(this.sparks);
        this.bLight = new Image("fireball.png");
        this.bLight.frame(BLIGHT);
        this.bLight.origin.set(this.bLight.width / 2.0f);
        this.bLight.angularSpeed = -90.0f;
        this.add(this.bLight);
        this.emitter = new Emitter();
        this.emitter.pour(new Emitter.Factory(){

            @Override
            public void emit(Emitter emitter, int index, float x, float y) {
                Flame p = (Flame)emitter.recycle(Flame.class);
                p.reset();
                p.x = x - p.width / 2.0f;
                p.y = y - p.height / 2.0f;
            }
        }, 0.1f);
        this.add(this.emitter);
        this.fLight = new Image("fireball.png");
        this.fLight.frame(FLIGHT);
        this.fLight.origin.set(this.fLight.width / 2.0f);
        this.fLight.angularSpeed = 360.0f;
        this.add(this.fLight);
        this.bLight.texture.filter(Texture.TextureFilter.Linear, Texture.TextureFilter.Linear);
    }

    @Override
    protected void layout() {
        this.bLight.x = this.x - this.bLight.width / 2.0f;
        this.bLight.y = this.y - this.bLight.height / 2.0f;
        this.emitter.pos(this.x - this.bLight.width / 4.0f, this.y - this.bLight.height / 4.0f, this.bLight.width / 2.0f, this.bLight.height / 2.0f);
        this.fLight.x = this.x - this.fLight.width / 2.0f;
        this.fLight.y = this.y - this.fLight.height / 2.0f;
    }

    @Override
    public void update() {
        super.update();
        if (Random.Float() < Game.elapsed) {
            PixelParticle spark = (PixelParticle)this.sparks.recycle(PixelParticle.Shrinking.class);
            spark.reset(this.x, this.y, ColorMath.random(0xFF66FF, 0x66FF66), 2.0f, Random.Float(0.5f, 1.0f));
            spark.speed.set(Random.Float(-40.0f, 40.0f), Random.Float(-60.0f, 20.0f));
            spark.acc.set(0.0f, 80.0f);
            this.sparks.add(spark);
        }
    }

    @Override
    public void draw() {
        Gdx.gl.glBlendFunc(770, 1);
        super.draw();
        Gdx.gl.glBlendFunc(770, 771);
    }

    public static class Flame
    extends Image {
        private static float LIFESPAN = 1.0f;
        private static float SPEED = -40.0f;
        private static float ACC = -20.0f;
        private float timeLeft;

        public Flame() {
            super("fireball.png");
            this.frame(Random.Int(2) == 0 ? FLAME1 : FLAME2);
            this.origin.set(this.width / 2.0f, this.height / 2.0f);
            this.acc.set(0.0f, ACC);
        }

        public void reset() {
            this.revive();
            this.timeLeft = LIFESPAN;
            this.speed.set(0.0f, SPEED);
        }

        @Override
        public void update() {
            float f;
            super.update();
            this.timeLeft -= Game.elapsed;
            if (f <= 0.0f) {
                this.kill();
            } else {
                float p = this.timeLeft / LIFESPAN;
                this.scale.set(p);
                this.alpha(p > 0.8f ? (1.0f - p) * 5.0f : p * 1.25f);
            }
        }
    }
}

