/*
 * Decompiled with CFR 0.152.
 */
package com.watabou.pixeldungeon.effects;

import com.badlogic.gdx.Gdx;
import com.watabou.noosa.Game;
import com.watabou.noosa.Image;
import com.watabou.noosa.audio.Sample;
import com.watabou.pixeldungeon.effects.Effects;
import com.watabou.utils.PointF;

public class DeathRay
extends Image {
    private static final double A = 57.29577951308232;
    private static final float DURATION = 0.5f;
    private float timeLeft;

    public DeathRay(PointF s, PointF e) {
        super(Effects.get(Effects.Type.RAY));
        this.origin.set(0.0f, this.height / 2.0f);
        this.x = s.x - this.origin.x;
        this.y = s.y - this.origin.y;
        float dx = e.x - s.x;
        float dy = e.y - s.y;
        this.angle = (float)(Math.atan2(dy, dx) * 57.29577951308232);
        this.scale.x = (float)Math.sqrt(dx * dx + dy * dy) / this.width;
        Sample.INSTANCE.play("snd_ray.mp3");
        this.timeLeft = 0.5f;
    }

    @Override
    public void update() {
        float f;
        super.update();
        float p = this.timeLeft / 0.5f;
        this.alpha(p);
        this.scale.set(this.scale.x, p);
        this.timeLeft -= Game.elapsed;
        if (f <= 0.0f) {
            this.killAndErase();
        }
    }

    @Override
    public void draw() {
        Gdx.gl.glBlendFunc(770, 1);
        super.draw();
        Gdx.gl.glBlendFunc(770, 771);
    }
}

