/*
 * Decompiled with CFR 0.152.
 */
package com.watabou.pixeldungeon.effects;

import com.watabou.noosa.Game;
import com.watabou.noosa.Image;
import com.watabou.noosa.TextureFilm;
import com.watabou.noosa.audio.Sample;
import com.watabou.pixeldungeon.effects.Speck;
import com.watabou.utils.PointF;

public class BadgeBanner
extends Image {
    private State state;
    private static final float DEFAULT_SCALE = 3.0f;
    private static final float FADE_IN_TIME = 0.2f;
    private static final float STATIC_TIME = 1.0f;
    private static final float FADE_OUT_TIME = 1.0f;
    private int index;
    private float time;
    private static TextureFilm atlas;
    private static BadgeBanner current;

    private BadgeBanner(int index) {
        super("badges.png");
        if (atlas == null) {
            atlas = new TextureFilm(this.texture, 16, 16);
        }
        this.index = index;
        this.frame(atlas.get(index));
        this.origin.set(this.width / 2.0f, this.height / 2.0f);
        this.alpha(0.0f);
        this.scale.set(6.0f);
        this.state = State.FADE_IN;
        this.time = 0.2f;
        Sample.INSTANCE.play("snd_badge.mp3");
    }

    @Override
    public void update() {
        super.update();
        this.time -= Game.elapsed;
        if (this.time >= 0.0f) {
            switch (this.state) {
                case FADE_IN: {
                    float p = this.time / 0.2f;
                    this.scale.set((1.0f + p) * 3.0f);
                    this.alpha(1.0f - p);
                    break;
                }
                case STATIC: {
                    break;
                }
                case FADE_OUT: {
                    this.alpha(this.time / 1.0f);
                }
            }
        } else {
            switch (this.state) {
                case FADE_IN: {
                    this.time = 1.0f;
                    this.state = State.STATIC;
                    this.scale.set(3.0f);
                    this.alpha(1.0f);
                    BadgeBanner.highlight(this, this.index);
                    break;
                }
                case STATIC: {
                    this.time = 1.0f;
                    this.state = State.FADE_OUT;
                    break;
                }
                case FADE_OUT: {
                    this.killAndErase();
                }
            }
        }
    }

    @Override
    public void kill() {
        if (current == this) {
            current = null;
        }
        super.kill();
    }

    public static void highlight(Image image, int index) {
        PointF p = new PointF();
        switch (index) {
            case 0: 
            case 1: 
            case 2: 
            case 3: {
                p.offset(7.0f, 3.0f);
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                p.offset(6.0f, 5.0f);
                break;
            }
            case 8: 
            case 9: 
            case 10: 
            case 11: {
                p.offset(6.0f, 3.0f);
                break;
            }
            case 12: 
            case 13: 
            case 14: 
            case 15: {
                p.offset(7.0f, 4.0f);
                break;
            }
            case 16: {
                p.offset(6.0f, 3.0f);
                break;
            }
            case 17: {
                p.offset(5.0f, 4.0f);
                break;
            }
            case 18: {
                p.offset(7.0f, 3.0f);
                break;
            }
            case 20: {
                p.offset(7.0f, 3.0f);
                break;
            }
            case 21: {
                p.offset(7.0f, 3.0f);
                break;
            }
            case 22: {
                p.offset(6.0f, 4.0f);
                break;
            }
            case 23: {
                p.offset(4.0f, 5.0f);
                break;
            }
            case 24: {
                p.offset(6.0f, 4.0f);
                break;
            }
            case 25: {
                p.offset(6.0f, 5.0f);
                break;
            }
            case 26: {
                p.offset(5.0f, 5.0f);
                break;
            }
            case 27: {
                p.offset(6.0f, 4.0f);
                break;
            }
            case 28: {
                p.offset(3.0f, 5.0f);
                break;
            }
            case 29: {
                p.offset(5.0f, 4.0f);
                break;
            }
            case 30: {
                p.offset(5.0f, 4.0f);
                break;
            }
            case 31: {
                p.offset(5.0f, 5.0f);
                break;
            }
            case 32: 
            case 33: {
                p.offset(7.0f, 4.0f);
                break;
            }
            case 34: {
                p.offset(6.0f, 4.0f);
                break;
            }
            case 35: {
                p.offset(6.0f, 4.0f);
                break;
            }
            case 36: {
                p.offset(6.0f, 5.0f);
                break;
            }
            case 37: {
                p.offset(4.0f, 4.0f);
                break;
            }
            case 38: {
                p.offset(5.0f, 5.0f);
                break;
            }
            case 39: {
                p.offset(5.0f, 4.0f);
                break;
            }
            case 40: 
            case 41: 
            case 42: 
            case 43: {
                p.offset(5.0f, 4.0f);
                break;
            }
            case 44: 
            case 45: 
            case 46: 
            case 47: {
                p.offset(5.0f, 5.0f);
                break;
            }
            case 48: 
            case 49: 
            case 50: 
            case 51: {
                p.offset(7.0f, 4.0f);
                break;
            }
            case 52: 
            case 53: 
            case 54: 
            case 55: {
                p.offset(4.0f, 4.0f);
                break;
            }
            case 56: {
                p.offset(3.0f, 7.0f);
                break;
            }
            case 57: {
                p.offset(4.0f, 5.0f);
                break;
            }
            case 58: {
                p.offset(6.0f, 4.0f);
                break;
            }
            case 59: {
                p.offset(7.0f, 4.0f);
                break;
            }
            case 60: 
            case 61: 
            case 62: 
            case 63: {
                p.offset(4.0f, 4.0f);
            }
        }
        p.x *= image.scale.x;
        p.y *= image.scale.y;
        p.offset(-image.origin.x * (image.scale.x - 1.0f), -image.origin.y * (image.scale.y - 1.0f));
        p.offset(image.point());
        Speck star = new Speck();
        star.reset(0, p.x, p.y, 101);
        star.camera = image.camera();
        image.parent.add(star);
    }

    public static BadgeBanner show(int image) {
        if (current != null) {
            current.killAndErase();
        }
        current = new BadgeBanner(image);
        return current;
    }

    public static Image image(int index) {
        Image image = new Image("badges.png");
        if (atlas == null) {
            atlas = new TextureFilm(image.texture, 16, 16);
        }
        image.frame(atlas.get(index));
        return image;
    }

    private static enum State {
        FADE_IN,
        STATIC,
        FADE_OUT;

    }
}

