/*
 * Decompiled with CFR 0.152.
 */
package com.watabou.pixeldungeon.actors.mobs.npcs;

import com.watabou.pixeldungeon.Dungeon;
import com.watabou.pixeldungeon.actors.mobs.npcs.Shopkeeper;
import com.watabou.pixeldungeon.effects.CellEmitter;
import com.watabou.pixeldungeon.effects.Speck;
import com.watabou.pixeldungeon.effects.particles.ElmoParticle;
import com.watabou.pixeldungeon.items.Heap;
import com.watabou.pixeldungeon.sprites.ImpSprite;
import com.watabou.pixeldungeon.utils.Utils;

public class ImpShopkeeper
extends Shopkeeper {
    private static final String TXT_GREETINGS = "Hello, friend!";
    private boolean seenBefore;

    public ImpShopkeeper() {
        this.name = "ambitious imp";
        this.spriteClass = ImpSprite.class;
        this.seenBefore = false;
    }

    @Override
    protected boolean act() {
        if (!this.seenBefore && Dungeon.visible[this.pos]) {
            this.yell(Utils.format(TXT_GREETINGS, new Object[0]));
            this.seenBefore = true;
        }
        return super.act();
    }

    @Override
    protected void flee() {
        for (Heap heap : Dungeon.level.heaps.values()) {
            if (heap.type != Heap.Type.FOR_SALE) continue;
            CellEmitter.get(heap.pos).burst(ElmoParticle.FACTORY, 4);
            heap.destroy();
        }
        this.destroy();
        this.sprite.emitter().burst(Speck.factory(7), 15);
        this.sprite.killAndErase();
    }

    @Override
    public String description() {
        return "Imps are lesser demons. They are notable for neither their strength nor their magic talent. But they are quite smart and sociable, and many of imps prefer to live and do business among non-demons.";
    }
}

