/*
 * Decompiled with CFR 0.152.
 */
package com.watabou.pixeldungeon.actors.mobs.npcs;

import com.watabou.pixeldungeon.Dungeon;
import com.watabou.pixeldungeon.Journal;
import com.watabou.pixeldungeon.actors.Actor;
import com.watabou.pixeldungeon.actors.Char;
import com.watabou.pixeldungeon.actors.buffs.Buff;
import com.watabou.pixeldungeon.actors.mobs.Golem;
import com.watabou.pixeldungeon.actors.mobs.Mob;
import com.watabou.pixeldungeon.actors.mobs.Monk;
import com.watabou.pixeldungeon.actors.mobs.npcs.NPC;
import com.watabou.pixeldungeon.items.Generator;
import com.watabou.pixeldungeon.items.Item;
import com.watabou.pixeldungeon.items.quest.DwarfToken;
import com.watabou.pixeldungeon.items.rings.Ring;
import com.watabou.pixeldungeon.levels.CityLevel;
import com.watabou.pixeldungeon.levels.Room;
import com.watabou.pixeldungeon.scenes.GameScene;
import com.watabou.pixeldungeon.sprites.ImpSprite;
import com.watabou.pixeldungeon.utils.Utils;
import com.watabou.pixeldungeon.windows.WndImp;
import com.watabou.pixeldungeon.windows.WndQuest;
import com.watabou.utils.Bundle;
import com.watabou.utils.Random;

public class Imp
extends NPC {
    private static final String TXT_GOLEMS1 = "Are you an adventurer? I love adventurers! You can always rely on them if something needs to be killed. Am I right? For bounty of course ;)\nIn my case this is _golems_ who need to be killed. You see, I'm going to start a little business here, but these stupid golems are bad for business! It's very hard to negotiate with wandering lumps of granite, damn them! So please, kill... let's say _6 of them_ and a reward is yours.";
    private static final String TXT_MONKS1 = "Are you an adventurer? I love adventurers! You can always rely on them if something needs to be killed. Am I right? For bounty of course ;)\nIn my case this is _monks_ who need to be killed. You see, I'm going to start a little business here, but these lunatics don't buy anything themselves and will scare away other customers. So please, kill... let's say _8 of them_ and a reward is yours.";
    private static final String TXT_GOLEMS2 = "How is your golem safari going?";
    private static final String TXT_MONKS2 = "Oh, you are still alive! I knew that your kung-fu is stronger ;) Just don't forget to grab these monks' tokens.";
    private static final String TXT_CYA = "See you, %s!";
    private static final String TXT_HEY = "Psst, %s!";
    private boolean seenBefore;

    public Imp() {
        this.name = "ambitious imp";
        this.spriteClass = ImpSprite.class;
        this.seenBefore = false;
    }

    @Override
    protected boolean act() {
        if (!Quest.given && Dungeon.visible[this.pos]) {
            if (!this.seenBefore) {
                this.yell(Utils.format(TXT_HEY, Dungeon.hero.className()));
            }
            this.seenBefore = true;
        } else {
            this.seenBefore = false;
        }
        this.throwItem();
        return super.act();
    }

    @Override
    public int defenseSkill(Char enemy) {
        return 1000;
    }

    @Override
    public String defenseVerb() {
        return "evaded";
    }

    @Override
    public void damage(int dmg, Object src) {
    }

    @Override
    public void add(Buff buff) {
    }

    @Override
    public boolean reset() {
        return true;
    }

    @Override
    public void interact() {
        this.sprite.turnTo(this.pos, Dungeon.hero.pos);
        if (Quest.given) {
            DwarfToken tokens = Dungeon.hero.belongings.getItem(DwarfToken.class);
            if (tokens != null && (tokens.quantity() >= 8 || !Quest.alternative && tokens.quantity() >= 6)) {
                GameScene.show(new WndImp(this, tokens));
            } else {
                this.tell(Quest.alternative ? TXT_MONKS2 : TXT_GOLEMS2, Dungeon.hero.className());
            }
        } else {
            this.tell(Quest.alternative ? TXT_MONKS1 : TXT_GOLEMS1, new Object[0]);
            Quest.given = true;
            Quest.completed = false;
            Journal.add(Journal.Feature.IMP);
        }
    }

    private void tell(String format, Object ... args) {
        GameScene.show(new WndQuest(this, Utils.format(format, args)));
    }

    public void flee() {
        this.yell(Utils.format(TXT_CYA, Dungeon.hero.className()));
        this.destroy();
        this.sprite.die();
    }

    @Override
    public String description() {
        return "Imps are lesser demons. They are notable for neither their strength nor their magic talent, but they are quite smart and sociable. Many imps prefer to live among non-demons.";
    }

    public static class Quest {
        private static boolean alternative;
        private static boolean spawned;
        private static boolean given;
        private static boolean completed;
        public static Ring reward;
        private static final String NODE = "demon";
        private static final String ALTERNATIVE = "alternative";
        private static final String SPAWNED = "spawned";
        private static final String GIVEN = "given";
        private static final String COMPLETED = "completed";
        private static final String REWARD = "reward";

        public static void reset() {
            spawned = false;
            reward = null;
        }

        public static void storeInBundle(Bundle bundle) {
            Bundle node = new Bundle();
            node.put(SPAWNED, spawned);
            if (spawned) {
                node.put(ALTERNATIVE, alternative);
                node.put(GIVEN, given);
                node.put(COMPLETED, completed);
                node.put(REWARD, reward);
            }
            bundle.put(NODE, node);
        }

        public static void restoreFromBundle(Bundle bundle) {
            Bundle node = bundle.getBundle(NODE);
            if (!node.isNull() && (spawned = node.getBoolean(SPAWNED))) {
                alternative = node.getBoolean(ALTERNATIVE);
                given = node.getBoolean(GIVEN);
                completed = node.getBoolean(COMPLETED);
                reward = (Ring)node.get(REWARD);
            }
        }

        public static void spawn(CityLevel level, Room room) {
            if (!spawned && Dungeon.depth > 16 && Random.Int(20 - Dungeon.depth) == 0) {
                Imp npc = new Imp();
                do {
                    npc.pos = level.randomRespawnCell();
                } while (npc.pos == -1 || level.heaps.get(npc.pos) != null);
                level.mobs.add(npc);
                Actor.occupyCell(npc);
                spawned = true;
                alternative = Random.Int(2) == 0;
                given = false;
                do {
                    reward = (Ring)Generator.random(Generator.Category.RING);
                } while (Quest.reward.cursed);
                reward.upgrade(2);
                Quest.reward.cursed = true;
            }
        }

        public static void process(Mob mob) {
            if (spawned && given && !completed && (alternative && mob instanceof Monk || !alternative && mob instanceof Golem)) {
                Dungeon.level.drop((Item)new DwarfToken(), (int)mob.pos).sprite.drop();
            }
        }

        public static void complete() {
            reward = null;
            completed = true;
            Journal.remove(Journal.Feature.IMP);
        }

        public static boolean isCompleted() {
            return completed;
        }
    }
}

