/*
 * Decompiled with CFR 0.152.
 */
package com.watabou.pixeldungeon.actors.mobs;

import com.watabou.pixeldungeon.Dungeon;
import com.watabou.pixeldungeon.actors.Char;
import com.watabou.pixeldungeon.actors.buffs.Buff;
import com.watabou.pixeldungeon.actors.buffs.Weakness;
import com.watabou.pixeldungeon.actors.mobs.Mob;
import com.watabou.pixeldungeon.items.Generator;
import com.watabou.pixeldungeon.items.weapon.enchantments.Death;
import com.watabou.pixeldungeon.levels.Level;
import com.watabou.pixeldungeon.mechanics.Ballistica;
import com.watabou.pixeldungeon.sprites.WarlockSprite;
import com.watabou.pixeldungeon.utils.GLog;
import com.watabou.pixeldungeon.utils.Utils;
import com.watabou.utils.Callback;
import com.watabou.utils.Random;
import java.util.HashSet;

public class Warlock
extends Mob
implements Callback {
    private static final float TIME_TO_ZAP = 1.0f;
    private static final String TXT_SHADOWBOLT_KILLED = "%s's shadow bolt killed you...";
    private static final HashSet<Class<?>> RESISTANCES = new HashSet();

    public Warlock() {
        this.name = "dwarf warlock";
        this.spriteClass = WarlockSprite.class;
        this.HT = 70;
        this.HP = 70;
        this.defenseSkill = 18;
        this.EXP = 11;
        this.maxLvl = 21;
        this.loot = Generator.Category.POTION;
        this.lootChance = 0.83f;
    }

    @Override
    public int damageRoll() {
        return Random.NormalIntRange(12, 20);
    }

    @Override
    public int attackSkill(Char target) {
        return 25;
    }

    @Override
    public int dr() {
        return 8;
    }

    @Override
    protected boolean canAttack(Char enemy) {
        return Ballistica.cast(this.pos, enemy.pos, false, true) == enemy.pos;
    }

    @Override
    protected boolean doAttack(Char enemy) {
        boolean visible;
        if (Level.adjacent(this.pos, enemy.pos)) {
            return super.doAttack(enemy);
        }
        boolean bl = visible = Level.fieldOfView[this.pos] || Level.fieldOfView[enemy.pos];
        if (visible) {
            ((WarlockSprite)this.sprite).zap(enemy.pos);
        } else {
            this.zap();
        }
        return !visible;
    }

    private void zap() {
        this.spend(1.0f);
        if (Warlock.hit(this, this.enemy, true)) {
            if (this.enemy == Dungeon.hero && Random.Int(2) == 0) {
                Buff.prolong(this.enemy, Weakness.class, Weakness.duration(this.enemy));
            }
            int dmg = Random.Int(12, 18);
            this.enemy.damage(dmg, this);
            if (!this.enemy.isAlive() && this.enemy == Dungeon.hero) {
                Dungeon.fail(Utils.format("Killed by %s on level %d", Utils.indefinite(this.name), Dungeon.depth));
                GLog.n(Utils.format(TXT_SHADOWBOLT_KILLED, this.name), new Object[0]);
            }
        } else {
            this.enemy.sprite.showStatus(0xFFFF00, this.enemy.defenseVerb(), new Object[0]);
        }
    }

    public void onZapComplete() {
        this.zap();
        this.next();
    }

    @Override
    public void call() {
        this.next();
    }

    @Override
    public String description() {
        return "When dwarves' interests have shifted from engineering to arcane arts, warlocks have come to power in the city. They started with elemental magic, but soon switched to demonology and necromancy.";
    }

    @Override
    public HashSet<Class<?>> resistances() {
        return RESISTANCES;
    }

    static {
        RESISTANCES.add(Death.class);
    }
}

