/*
 * Decompiled with CFR 0.152.
 */
package com.watabou.pixeldungeon.actors.mobs;

import com.watabou.pixeldungeon.Badges;
import com.watabou.pixeldungeon.Dungeon;
import com.watabou.pixeldungeon.Statistics;
import com.watabou.pixeldungeon.actors.Char;
import com.watabou.pixeldungeon.actors.blobs.ToxicGas;
import com.watabou.pixeldungeon.actors.buffs.Burning;
import com.watabou.pixeldungeon.actors.buffs.Frost;
import com.watabou.pixeldungeon.actors.buffs.Paralysis;
import com.watabou.pixeldungeon.actors.buffs.Roots;
import com.watabou.pixeldungeon.actors.mobs.Mob;
import com.watabou.pixeldungeon.items.Item;
import com.watabou.pixeldungeon.items.food.MysteryMeat;
import com.watabou.pixeldungeon.levels.Level;
import com.watabou.pixeldungeon.sprites.PiranhaSprite;
import com.watabou.utils.Random;
import java.util.HashSet;

public class Piranha
extends Mob {
    private static final HashSet<Class<?>> IMMUNITIES = new HashSet();

    public Piranha() {
        this.name = "giant piranha";
        this.spriteClass = PiranhaSprite.class;
        this.baseSpeed = 2.0f;
        this.EXP = 0;
        this.HP = this.HT = 10 + Dungeon.depth * 5;
        this.defenseSkill = 10 + Dungeon.depth * 2;
    }

    @Override
    protected boolean act() {
        if (!Level.water[this.pos]) {
            this.die(null);
            return true;
        }
        return super.act();
    }

    @Override
    public int damageRoll() {
        return Random.NormalIntRange(Dungeon.depth, 4 + Dungeon.depth * 2);
    }

    @Override
    public int attackSkill(Char target) {
        return 20 + Dungeon.depth * 2;
    }

    @Override
    public int dr() {
        return Dungeon.depth;
    }

    @Override
    public void die(Object cause) {
        Dungeon.level.drop((Item)new MysteryMeat(), (int)this.pos).sprite.drop();
        super.die(cause);
        ++Statistics.piranhasKilled;
        Badges.validatePiranhasKilled();
    }

    @Override
    public boolean reset() {
        return true;
    }

    @Override
    protected boolean getCloser(int target) {
        if (this.rooted) {
            return false;
        }
        int step = Dungeon.findPath(this, this.pos, target, Level.water, Level.fieldOfView);
        if (step != -1) {
            this.move(step);
            return true;
        }
        return false;
    }

    @Override
    protected boolean getFurther(int target) {
        int step = Dungeon.flee(this, this.pos, target, Level.water, Level.fieldOfView);
        if (step != -1) {
            this.move(step);
            return true;
        }
        return false;
    }

    @Override
    public String description() {
        return "These carnivorous fish are not natural inhabitants of underground pools. They were bred specifically to protect flooded treasure vaults.";
    }

    @Override
    public HashSet<Class<?>> immunities() {
        return IMMUNITIES;
    }

    static {
        IMMUNITIES.add(Burning.class);
        IMMUNITIES.add(Paralysis.class);
        IMMUNITIES.add(ToxicGas.class);
        IMMUNITIES.add(Roots.class);
        IMMUNITIES.add(Frost.class);
    }
}

