/*
 * Decompiled with CFR 0.152.
 */
package com.watabou.pixeldungeon.actors.mobs;

import com.watabou.pixeldungeon.actors.Char;
import com.watabou.pixeldungeon.actors.buffs.Amok;
import com.watabou.pixeldungeon.actors.buffs.Sleep;
import com.watabou.pixeldungeon.actors.buffs.Terror;
import com.watabou.pixeldungeon.actors.mobs.Mob;
import com.watabou.pixeldungeon.actors.mobs.npcs.Imp;
import com.watabou.pixeldungeon.items.scrolls.ScrollOfPsionicBlast;
import com.watabou.pixeldungeon.sprites.GolemSprite;
import com.watabou.utils.Random;
import java.util.HashSet;

public class Golem
extends Mob {
    private static final HashSet<Class<?>> RESISTANCES = new HashSet();
    private static final HashSet<Class<?>> IMMUNITIES;

    public Golem() {
        this.name = "golem";
        this.spriteClass = GolemSprite.class;
        this.HT = 85;
        this.HP = 85;
        this.defenseSkill = 18;
        this.EXP = 12;
        this.maxLvl = 22;
    }

    @Override
    public int damageRoll() {
        return Random.NormalIntRange(20, 40);
    }

    @Override
    public int attackSkill(Char target) {
        return 28;
    }

    @Override
    protected float attackDelay() {
        return 1.5f;
    }

    @Override
    public int dr() {
        return 12;
    }

    @Override
    public String defenseVerb() {
        return "blocked";
    }

    @Override
    public void die(Object cause) {
        Imp.Quest.process(this);
        super.die(cause);
    }

    @Override
    public String description() {
        return "The Dwarves tried to combine their knowledge of mechanisms with their newfound power of elemental binding. They used spirits of earth as the \"soul\" for the mechanical bodies of golems, which were believed to be most controllable of all. Despite this, the tiniest mistake in the ritual could cause an outbreak.";
    }

    @Override
    public HashSet<Class<?>> resistances() {
        return RESISTANCES;
    }

    @Override
    public HashSet<Class<?>> immunities() {
        return IMMUNITIES;
    }

    static {
        RESISTANCES.add(ScrollOfPsionicBlast.class);
        IMMUNITIES = new HashSet();
        IMMUNITIES.add(Amok.class);
        IMMUNITIES.add(Terror.class);
        IMMUNITIES.add(Sleep.class);
    }
}

