/*
 * Decompiled with CFR 0.152.
 */
package com.watabou.pixeldungeon.actors.mobs;

import com.badlogic.gdx.utils.reflect.ClassReflection;
import com.watabou.pixeldungeon.actors.Char;
import com.watabou.pixeldungeon.actors.mobs.Acidic;
import com.watabou.pixeldungeon.actors.mobs.Albino;
import com.watabou.pixeldungeon.actors.mobs.Bandit;
import com.watabou.pixeldungeon.actors.mobs.Bat;
import com.watabou.pixeldungeon.actors.mobs.Brute;
import com.watabou.pixeldungeon.actors.mobs.Crab;
import com.watabou.pixeldungeon.actors.mobs.DM300;
import com.watabou.pixeldungeon.actors.mobs.Elemental;
import com.watabou.pixeldungeon.actors.mobs.Eye;
import com.watabou.pixeldungeon.actors.mobs.Gnoll;
import com.watabou.pixeldungeon.actors.mobs.Golem;
import com.watabou.pixeldungeon.actors.mobs.Goo;
import com.watabou.pixeldungeon.actors.mobs.King;
import com.watabou.pixeldungeon.actors.mobs.Mob;
import com.watabou.pixeldungeon.actors.mobs.Monk;
import com.watabou.pixeldungeon.actors.mobs.Rat;
import com.watabou.pixeldungeon.actors.mobs.Scorpio;
import com.watabou.pixeldungeon.actors.mobs.Senior;
import com.watabou.pixeldungeon.actors.mobs.Shaman;
import com.watabou.pixeldungeon.actors.mobs.Shielded;
import com.watabou.pixeldungeon.actors.mobs.Skeleton;
import com.watabou.pixeldungeon.actors.mobs.Spinner;
import com.watabou.pixeldungeon.actors.mobs.Succubus;
import com.watabou.pixeldungeon.actors.mobs.Swarm;
import com.watabou.pixeldungeon.actors.mobs.Tengu;
import com.watabou.pixeldungeon.actors.mobs.Thief;
import com.watabou.pixeldungeon.actors.mobs.Warlock;
import com.watabou.pixeldungeon.actors.mobs.Yog;
import com.watabou.utils.Random;

public class Bestiary {
    public static Mob mob(int depth) {
        Class<?> cl = Bestiary.mobClass(depth);
        try {
            return (Mob)ClassReflection.newInstance(cl);
        }
        catch (Exception e) {
            return null;
        }
    }

    public static Mob mutable(int depth) {
        Class<Object> cl = Bestiary.mobClass(depth);
        if (Random.Int(30) == 0) {
            if (cl == Rat.class) {
                cl = Albino.class;
            } else if (cl == Thief.class) {
                cl = Bandit.class;
            } else if (cl == Brute.class) {
                cl = Shielded.class;
            } else if (cl == Monk.class) {
                cl = Senior.class;
            } else if (cl == Scorpio.class) {
                cl = Acidic.class;
            }
        }
        try {
            return (Mob)ClassReflection.newInstance(cl);
        }
        catch (Exception e) {
            return null;
        }
    }

    private static Class<?> mobClass(int depth) {
        Class[] classes;
        float[] chances;
        switch (depth) {
            case 1: {
                chances = new float[]{1.0f};
                classes = new Class[]{Rat.class};
                break;
            }
            case 2: {
                chances = new float[]{1.0f, 1.0f};
                classes = new Class[]{Rat.class, Gnoll.class};
                break;
            }
            case 3: {
                chances = new float[]{1.0f, 2.0f, 1.0f, 0.02f};
                classes = new Class[]{Rat.class, Gnoll.class, Crab.class, Swarm.class};
                break;
            }
            case 4: {
                chances = new float[]{1.0f, 2.0f, 3.0f, 0.02f, 0.01f, 0.01f};
                classes = new Class[]{Rat.class, Gnoll.class, Crab.class, Swarm.class, Skeleton.class, Thief.class};
                break;
            }
            case 5: {
                chances = new float[]{1.0f};
                classes = new Class[]{Goo.class};
                break;
            }
            case 6: {
                chances = new float[]{4.0f, 2.0f, 1.0f, 0.2f};
                classes = new Class[]{Skeleton.class, Thief.class, Swarm.class, Shaman.class};
                break;
            }
            case 7: {
                chances = new float[]{3.0f, 1.0f, 1.0f, 1.0f};
                classes = new Class[]{Skeleton.class, Shaman.class, Thief.class, Swarm.class};
                break;
            }
            case 8: {
                chances = new float[]{3.0f, 2.0f, 1.0f, 1.0f, 1.0f, 0.02f};
                classes = new Class[]{Skeleton.class, Shaman.class, Gnoll.class, Thief.class, Swarm.class, Bat.class};
                break;
            }
            case 9: {
                chances = new float[]{3.0f, 3.0f, 1.0f, 1.0f, 0.02f, 0.01f};
                classes = new Class[]{Skeleton.class, Shaman.class, Thief.class, Swarm.class, Bat.class, Brute.class};
                break;
            }
            case 10: {
                chances = new float[]{1.0f};
                classes = new Class[]{Tengu.class};
                break;
            }
            case 11: {
                chances = new float[]{1.0f, 0.2f};
                classes = new Class[]{Bat.class, Brute.class};
                break;
            }
            case 12: {
                chances = new float[]{1.0f, 1.0f, 0.2f};
                classes = new Class[]{Bat.class, Brute.class, Spinner.class};
                break;
            }
            case 13: {
                chances = new float[]{1.0f, 3.0f, 1.0f, 1.0f, 0.02f};
                classes = new Class[]{Bat.class, Brute.class, Shaman.class, Spinner.class, Elemental.class};
                break;
            }
            case 14: {
                chances = new float[]{1.0f, 3.0f, 1.0f, 4.0f, 0.02f, 0.01f};
                classes = new Class[]{Bat.class, Brute.class, Shaman.class, Spinner.class, Elemental.class, Monk.class};
                break;
            }
            case 15: {
                chances = new float[]{1.0f};
                classes = new Class[]{DM300.class};
                break;
            }
            case 16: {
                chances = new float[]{1.0f, 1.0f, 0.2f};
                classes = new Class[]{Elemental.class, Warlock.class, Monk.class};
                break;
            }
            case 17: {
                chances = new float[]{1.0f, 1.0f, 1.0f};
                classes = new Class[]{Elemental.class, Monk.class, Warlock.class};
                break;
            }
            case 18: {
                chances = new float[]{1.0f, 2.0f, 1.0f, 1.0f};
                classes = new Class[]{Elemental.class, Monk.class, Golem.class, Warlock.class};
                break;
            }
            case 19: {
                chances = new float[]{1.0f, 2.0f, 3.0f, 1.0f, 0.02f};
                classes = new Class[]{Elemental.class, Monk.class, Golem.class, Warlock.class, Succubus.class};
                break;
            }
            case 20: {
                chances = new float[]{1.0f};
                classes = new Class[]{King.class};
                break;
            }
            case 22: {
                chances = new float[]{1.0f, 1.0f};
                classes = new Class[]{Succubus.class, Eye.class};
                break;
            }
            case 23: {
                chances = new float[]{1.0f, 2.0f, 1.0f};
                classes = new Class[]{Succubus.class, Eye.class, Scorpio.class};
                break;
            }
            case 24: {
                chances = new float[]{1.0f, 2.0f, 3.0f};
                classes = new Class[]{Succubus.class, Eye.class, Scorpio.class};
                break;
            }
            case 25: {
                chances = new float[]{1.0f};
                classes = new Class[]{Yog.class};
                break;
            }
            default: {
                chances = new float[]{1.0f};
                classes = new Class[]{Eye.class};
            }
        }
        return classes[Random.chances(chances)];
    }

    public static boolean isUnique(Char mob) {
        return mob instanceof Goo || mob instanceof Tengu || mob instanceof DM300 || mob instanceof King || mob instanceof Yog;
    }
}

