/*
 * Decompiled with CFR 0.152.
 */
package com.watabou.pixeldungeon.actors.hero;

import com.watabou.pixeldungeon.Badges;
import com.watabou.pixeldungeon.Dungeon;
import com.watabou.pixeldungeon.actors.hero.Hero;
import com.watabou.pixeldungeon.items.TomeOfMastery;
import com.watabou.pixeldungeon.items.armor.ClothArmor;
import com.watabou.pixeldungeon.items.food.Food;
import com.watabou.pixeldungeon.items.potions.PotionOfStrength;
import com.watabou.pixeldungeon.items.rings.RingOfShadows;
import com.watabou.pixeldungeon.items.scrolls.ScrollOfIdentify;
import com.watabou.pixeldungeon.items.scrolls.ScrollOfMagicMapping;
import com.watabou.pixeldungeon.items.wands.WandOfMagicMissile;
import com.watabou.pixeldungeon.items.weapon.melee.Dagger;
import com.watabou.pixeldungeon.items.weapon.melee.Knuckles;
import com.watabou.pixeldungeon.items.weapon.melee.ShortSword;
import com.watabou.pixeldungeon.items.weapon.missiles.Boomerang;
import com.watabou.pixeldungeon.items.weapon.missiles.Dart;
import com.watabou.utils.Bundle;

public enum HeroClass {
    WARRIOR("warrior"),
    MAGE("mage"),
    ROGUE("rogue"),
    HUNTRESS("huntress");

    private String title;
    public static final String[] WAR_PERKS;
    public static final String[] MAG_PERKS;
    public static final String[] ROG_PERKS;
    public static final String[] HUN_PERKS;
    private static final String CLASS = "class";

    private HeroClass(String title) {
        this.title = title;
    }

    public void initHero(Hero hero) {
        hero.heroClass = this;
        HeroClass.initCommon(hero);
        switch (this) {
            case WARRIOR: {
                HeroClass.initWarrior(hero);
                break;
            }
            case MAGE: {
                HeroClass.initMage(hero);
                break;
            }
            case ROGUE: {
                HeroClass.initRogue(hero);
                break;
            }
            case HUNTRESS: {
                HeroClass.initHuntress(hero);
            }
        }
        if (Badges.isUnlocked(this.masteryBadge())) {
            new TomeOfMastery().collect();
        }
        hero.updateAwareness();
    }

    private static void initCommon(Hero hero) {
        hero.belongings.armor = new ClothArmor();
        hero.belongings.armor.identify();
        new Food().identify().collect();
    }

    public Badges.Badge masteryBadge() {
        switch (this) {
            case WARRIOR: {
                return Badges.Badge.MASTERY_WARRIOR;
            }
            case MAGE: {
                return Badges.Badge.MASTERY_MAGE;
            }
            case ROGUE: {
                return Badges.Badge.MASTERY_ROGUE;
            }
            case HUNTRESS: {
                return Badges.Badge.MASTERY_HUNTRESS;
            }
        }
        return null;
    }

    private static void initWarrior(Hero hero) {
        ++hero.STR;
        hero.belongings.weapon = new ShortSword();
        hero.belongings.weapon.identify();
        new Dart(8).identify().collect();
        Dungeon.quickslot = Dart.class;
        new PotionOfStrength().setKnown();
    }

    private static void initMage(Hero hero) {
        hero.belongings.weapon = new Knuckles();
        hero.belongings.weapon.identify();
        WandOfMagicMissile wand = new WandOfMagicMissile();
        wand.identify().collect();
        Dungeon.quickslot = wand;
        new ScrollOfIdentify().setKnown();
    }

    private static void initRogue(Hero hero) {
        hero.belongings.weapon = new Dagger();
        hero.belongings.weapon.identify();
        hero.belongings.ring1 = new RingOfShadows();
        hero.belongings.ring1.upgrade().identify();
        new Dart(8).identify().collect();
        hero.belongings.ring1.activate(hero);
        Dungeon.quickslot = Dart.class;
        new ScrollOfMagicMapping().setKnown();
    }

    private static void initHuntress(Hero hero) {
        hero.HP = hero.HT -= 5;
        hero.belongings.weapon = new Dagger();
        hero.belongings.weapon.identify();
        Boomerang boomerang = new Boomerang();
        boomerang.identify().collect();
        Dungeon.quickslot = boomerang;
    }

    public String title() {
        return this.title;
    }

    public String spritesheet() {
        switch (this) {
            case WARRIOR: {
                return "warrior.png";
            }
            case MAGE: {
                return "mage.png";
            }
            case ROGUE: {
                return "rogue.png";
            }
            case HUNTRESS: {
                return "ranger.png";
            }
        }
        return null;
    }

    public String[] perks() {
        switch (this) {
            case WARRIOR: {
                return WAR_PERKS;
            }
            case MAGE: {
                return MAG_PERKS;
            }
            case ROGUE: {
                return ROG_PERKS;
            }
            case HUNTRESS: {
                return HUN_PERKS;
            }
        }
        return null;
    }

    public void storeInBundle(Bundle bundle) {
        bundle.put(CLASS, this.toString());
    }

    public static HeroClass restoreInBundle(Bundle bundle) {
        String value = bundle.getString(CLASS);
        return value.length() > 0 ? HeroClass.valueOf(value) : ROGUE;
    }

    static {
        WAR_PERKS = new String[]{"Warriors start with 11 points of Strength.", "Warriors start with a unique short sword. This sword can be later \"reforged\" to upgrade another melee weapon.", "Warriors are less proficient with missile weapons.", "Any piece of food restores some health when eaten.", "Potions of Strength are identified from the beginning."};
        MAG_PERKS = new String[]{"Mages start with a unique Wand of Magic Missile. This wand can be later \"disenchanted\" to upgrade another wand.", "Mages recharge their wands faster.", "When eaten, any piece of food restores 1 charge for all wands in the inventory.", "Mages can use wands as a melee weapon.", "Scrolls of Identify are identified from the beginning."};
        ROG_PERKS = new String[]{"Rogues start with a Ring of Shadows+1.", "Rogues identify a type of a ring on equipping it.", "Rogues are proficient with light armor, dodging better while wearing one.", "Rogues are proficient in detecting hidden doors and traps.", "Rogues can go without food longer.", "Scrolls of Magic Mapping are identified from the beginning."};
        HUN_PERKS = new String[]{"Huntresses start with 15 points of Health.", "Huntresses start with a unique upgradeable boomerang.", "Huntresses are proficient with missile weapons and get damage bonus for excessive strength when using them.", "Huntresses gain more health from dewdrops.", "Huntresses sense neighbouring monsters even if they are hidden behind obstacles."};
    }
}

