/*
 * Decompiled with CFR 0.152.
 */
package com.watabou.pixeldungeon.actors.buffs;

import com.badlogic.gdx.utils.reflect.ClassReflection;
import com.watabou.pixeldungeon.actors.Actor;
import com.watabou.pixeldungeon.actors.Char;
import com.watabou.pixeldungeon.actors.buffs.FlavourBuff;

public class Buff
extends Actor {
    public Char target;

    public boolean attachTo(Char target) {
        if (target.immunities().contains(this.getClass())) {
            return false;
        }
        this.target = target;
        target.add(this);
        return true;
    }

    public void detach() {
        this.target.remove(this);
    }

    @Override
    public boolean act() {
        this.diactivate();
        return true;
    }

    public int icon() {
        return -1;
    }

    public static <T extends Buff> T affect(Char target, Class<T> buffClass) {
        Object buff = target.buff(buffClass);
        if (buff != null) {
            return buff;
        }
        try {
            buff = (Buff)ClassReflection.newInstance(buffClass);
            ((Buff)buff).attachTo(target);
            return buff;
        }
        catch (Exception e) {
            return null;
        }
    }

    public static <T extends FlavourBuff> T affect(Char target, Class<T> buffClass, float duration) {
        FlavourBuff buff = (FlavourBuff)Buff.affect(target, buffClass);
        buff.spend(duration);
        return (T)buff;
    }

    public static <T extends FlavourBuff> T prolong(Char target, Class<T> buffClass, float duration) {
        FlavourBuff buff = (FlavourBuff)Buff.affect(target, buffClass);
        buff.postpone(duration);
        return (T)buff;
    }

    public static void detach(Buff buff) {
        if (buff != null) {
            buff.detach();
        }
    }

    public static void detach(Char target, Class<? extends Buff> cl) {
        Buff.detach(target.buff(cl));
    }
}

