/*
 * Decompiled with CFR 0.152.
 */
package com.watabou.pixeldungeon.actors.blobs;

import com.watabou.pixeldungeon.Dungeon;
import com.watabou.pixeldungeon.Journal;
import com.watabou.pixeldungeon.actors.blobs.Blob;
import com.watabou.pixeldungeon.actors.blobs.WaterOfAwareness;
import com.watabou.pixeldungeon.actors.blobs.WaterOfHealth;
import com.watabou.pixeldungeon.actors.blobs.WaterOfTransmutation;
import com.watabou.pixeldungeon.actors.hero.Hero;
import com.watabou.pixeldungeon.items.Heap;
import com.watabou.pixeldungeon.items.Item;
import com.watabou.pixeldungeon.levels.Level;
import com.watabou.pixeldungeon.scenes.GameScene;
import com.watabou.utils.Bundle;
import com.watabou.utils.Random;

public class WellWater
extends Blob {
    protected int pos;

    @Override
    public void restoreFromBundle(Bundle bundle) {
        super.restoreFromBundle(bundle);
        for (int i = 0; i < 1024; ++i) {
            if (this.cur[i] <= 0) continue;
            this.pos = i;
            break;
        }
    }

    @Override
    protected void evolve() {
        this.volume = this.off[this.pos] = this.cur[this.pos];
        if (Dungeon.visible[this.pos]) {
            if (this instanceof WaterOfAwareness) {
                Journal.add(Journal.Feature.WELL_OF_AWARENESS);
            } else if (this instanceof WaterOfHealth) {
                Journal.add(Journal.Feature.WELL_OF_HEALTH);
            } else if (this instanceof WaterOfTransmutation) {
                Journal.add(Journal.Feature.WELL_OF_TRANSMUTATION);
            }
        }
    }

    protected boolean affect() {
        if (this.pos == Dungeon.hero.pos && this.affectHero(Dungeon.hero)) {
            this.cur[this.pos] = 0;
            this.off[this.pos] = 0;
            this.volume = 0;
            return true;
        }
        Heap heap = (Heap)Dungeon.level.heaps.get(this.pos);
        if (heap != null) {
            int newPlace;
            Item oldItem = heap.peek();
            Item newItem = this.affectItem(oldItem);
            if (newItem != null) {
                if (newItem != oldItem) {
                    if (oldItem.quantity() > 1) {
                        oldItem.quantity(oldItem.quantity() - 1);
                        heap.drop(newItem);
                    } else {
                        heap.replace(oldItem, newItem);
                    }
                }
                heap.sprite.link();
                this.cur[this.pos] = 0;
                this.off[this.pos] = 0;
                this.volume = 0;
                return true;
            }
            while (!Level.passable[newPlace = this.pos + Level.NEIGHBOURS8[Random.Int(8)]] && !Level.avoid[newPlace]) {
            }
            Dungeon.level.drop((Item)heap.pickUp(), (int)newPlace).sprite.drop(this.pos);
            return false;
        }
        return false;
    }

    protected boolean affectHero(Hero hero) {
        return false;
    }

    protected Item affectItem(Item item) {
        return null;
    }

    @Override
    public void seed(int cell, int amount) {
        this.cur[this.pos] = 0;
        this.pos = cell;
        this.volume = this.cur[this.pos] = amount;
    }

    public static void affectCell(int cell) {
        Class[] waters;
        for (Class waterClass : waters = new Class[]{WaterOfHealth.class, WaterOfAwareness.class, WaterOfTransmutation.class}) {
            WellWater water = (WellWater)Dungeon.level.blobs.get(waterClass);
            if (water == null || water.volume <= 0 || water.pos != cell || !water.affect()) continue;
            Level.set(cell, 3);
            GameScene.updateMap(cell);
            return;
        }
    }
}

