/*
 * Decompiled with CFR 0.152.
 */
package com.watabou.pixeldungeon.actors.blobs;

import com.watabou.pixeldungeon.Dungeon;
import com.watabou.pixeldungeon.actors.Actor;
import com.watabou.pixeldungeon.actors.Char;
import com.watabou.pixeldungeon.actors.blobs.Blob;
import com.watabou.pixeldungeon.actors.buffs.Buff;
import com.watabou.pixeldungeon.actors.buffs.Roots;
import com.watabou.pixeldungeon.effects.BlobEmitter;
import com.watabou.pixeldungeon.effects.particles.LeafParticle;
import com.watabou.pixeldungeon.levels.Level;
import com.watabou.pixeldungeon.scenes.GameScene;

public class Regrowth
extends Blob {
    @Override
    protected void evolve() {
        super.evolve();
        if (this.volume > 0) {
            boolean mapUpdated = false;
            for (int i = 0; i < 1024; ++i) {
                if (this.off[i] <= 0) continue;
                int c = Dungeon.level.map[i];
                if (c == 1 || c == 9 || c == 24) {
                    Level.set(i, this.cur[i] > 9 ? 15 : 2);
                    mapUpdated = true;
                } else if (c == 2 && this.cur[i] > 9) {
                    Level.set(i, 15);
                    mapUpdated = true;
                }
                Char ch = Actor.findChar(i);
                if (ch == null) continue;
                Buff.prolong(ch, Roots.class, 1.0f);
            }
            if (mapUpdated) {
                GameScene.updateMap();
                Dungeon.observe();
            }
        }
    }

    @Override
    public void use(BlobEmitter emitter) {
        super.use(emitter);
        emitter.start(LeafParticle.LEVEL_SPECIFIC, 0.2f, 0);
    }
}

