/*
 * Decompiled with CFR 0.152.
 */
package com.watabou.pixeldungeon.actors.blobs;

import com.badlogic.gdx.utils.reflect.ClassReflection;
import com.watabou.pixeldungeon.Dungeon;
import com.watabou.pixeldungeon.PixelDungeon;
import com.watabou.pixeldungeon.actors.Actor;
import com.watabou.pixeldungeon.effects.BlobEmitter;
import com.watabou.pixeldungeon.levels.Level;
import com.watabou.pixeldungeon.utils.BArray;
import com.watabou.utils.Bundle;
import java.util.Arrays;

public class Blob
extends Actor {
    public static final int WIDTH = 32;
    public static final int HEIGHT = 32;
    public static final int LENGTH = 1024;
    public int volume = 0;
    public int[] cur = new int[1024];
    protected int[] off = new int[1024];
    public BlobEmitter emitter;
    private static final String CUR = "cur";
    private static final String START = "start";

    protected Blob() {
    }

    @Override
    public void storeInBundle(Bundle bundle) {
        super.storeInBundle(bundle);
        if (this.volume > 0) {
            int end;
            int start;
            for (start = 0; start < 1024 && this.cur[start] <= 0; ++start) {
            }
            for (end = 1023; end > start && this.cur[end] <= 0; --end) {
            }
            bundle.put(START, start);
            bundle.put(CUR, this.trim(start, end + 1));
        }
    }

    private int[] trim(int start, int end) {
        int len = end - start;
        int[] copy = new int[len];
        System.arraycopy(this.cur, start, copy, 0, len);
        return copy;
    }

    @Override
    public void restoreFromBundle(Bundle bundle) {
        super.restoreFromBundle(bundle);
        int[] data = bundle.getIntArray(CUR);
        if (data != null) {
            int start = bundle.getInt(START);
            for (int i = 0; i < data.length; ++i) {
                this.cur[i + start] = data[i];
                this.volume += data[i];
            }
        }
        if (Level.resizingNeeded) {
            int[] cur = new int[1024];
            Arrays.fill(cur, 0);
            int loadedMapSize = Level.loadedMapSize;
            for (int i = 0; i < loadedMapSize; ++i) {
                System.arraycopy(this.cur, i * loadedMapSize, cur, i * 32, loadedMapSize);
            }
            this.cur = cur;
        }
    }

    @Override
    public boolean act() {
        this.spend(1.0f);
        if (this.volume > 0) {
            this.volume = 0;
            this.evolve();
            int[] tmp = this.off;
            this.off = this.cur;
            this.cur = tmp;
        }
        return true;
    }

    public void use(BlobEmitter emitter) {
        this.emitter = emitter;
    }

    protected void evolve() {
        boolean[] notBlocking = BArray.not(Level.solid, null);
        for (int i = 1; i < 31; ++i) {
            int from = i * 32 + 1;
            int to = from + 32 - 2;
            for (int pos = from; pos < to; ++pos) {
                if (notBlocking[pos]) {
                    int value;
                    int count = 1;
                    int sum = this.cur[pos];
                    if (notBlocking[pos - 1]) {
                        sum += this.cur[pos - 1];
                        ++count;
                    }
                    if (notBlocking[pos + 1]) {
                        sum += this.cur[pos + 1];
                        ++count;
                    }
                    if (notBlocking[pos - 32]) {
                        sum += this.cur[pos - 32];
                        ++count;
                    }
                    if (notBlocking[pos + 32]) {
                        sum += this.cur[pos + 32];
                        ++count;
                    }
                    this.off[pos] = value = sum >= count ? sum / count - 1 : 0;
                    this.volume += value;
                    continue;
                }
                this.off[pos] = 0;
            }
        }
    }

    public void seed(int cell, int amount) {
        int n = cell;
        this.cur[n] = this.cur[n] + amount;
        this.volume += amount;
    }

    public void clear(int cell) {
        this.volume -= this.cur[cell];
        this.cur[cell] = 0;
    }

    public String tileDesc() {
        return null;
    }

    public static <T extends Blob> T seed(int cell, int amount, Class<T> type) {
        try {
            Blob gas = Dungeon.level.blobs.get(type);
            if (gas == null) {
                gas = (Blob)ClassReflection.newInstance(type);
                Dungeon.level.blobs.put(type, gas);
            }
            gas.seed(cell, amount);
            return (T)gas;
        }
        catch (Exception e) {
            PixelDungeon.reportException(e);
            return null;
        }
    }
}

